package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.special.refunds.receive.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class SpecialRefundsReceiveGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 5191119274413599995L;

	/** 
	 * 是否存在下一页
	 */
	@ApiField("has_next")
	private Boolean hasNext;

	/** 
	 * 搜索到的退款信息列表
	 */
	@ApiListField("refunds")
	@ApiField("refund")
	private List<Refund> refunds;

	/** 
	 * 搜索到的退款信息总数
	 */
	@ApiField("total_results")
	private Long totalResults;


	public void setHasNext(Boolean hasNext) {
		this.hasNext = hasNext;
	}
	public Boolean getHasNext( ) {
		return this.hasNext;
	}

	public void setRefunds(List<Refund> refunds) {
		this.refunds = refunds;
	}
	public List<Refund> getRefunds( ) {
		return this.refunds;
	}

	public void setTotalResults(Long totalResults) {
		this.totalResults = totalResults;
	}
	public Long getTotalResults( ) {
		return this.totalResults;
	}
	
	/**
 * 价保信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PriceProtection extends TaobaoObject {

	private static final long serialVersionUID = 6615418132777265516L;

	/**
		 * 价保申请时间
		 */
		@ApiField("created_time")
		private Date createdTime;
		/**
		 * 平台出资金额。精确到2位小数;单位:元。如:200.07，表示:200元7分
		 */
		@ApiField("platform_refund_fee")
		private String platformRefundFee;
		/**
		 * 平台出资状态。1表示无需创建，2表示待创建，3表示进行中，4表示成功，5表示失败，6表示关闭。只有4是已成功出资。
		 */
		@ApiField("platform_refund_status")
		private Long platformRefundStatus;
		/**
		 * 价保单id，标识一次价保
		 */
		@ApiField("price_protection_id")
		private Long priceProtectionId;
		/**
		 * 价保场景。"pp"表示价保，"mgbp"表示买贵必赔，"pc"表示价差赔付。
		 */
		@ApiField("scene")
		private String scene;
		/**
		 * 商家出资金额。精确到2位小数;单位:元。如:200.07，表示:200元7分
		 */
		@ApiField("seller_refund_fee")
		private String sellerRefundFee;
		/**
		 * 商家出资状态。1表示无需创建，2表示待创建，3表示进行中，4表示成功，5表示失败，6表示关闭。只有4是已成功出资。
		 */
		@ApiField("seller_refund_status")
		private Long sellerRefundStatus;
	

	public Date getCreatedTime() {
			return this.createdTime;
		}
		public void setCreatedTime(Date createdTime) {
			this.createdTime = createdTime;
		}
		public String getPlatformRefundFee() {
			return this.platformRefundFee;
		}
		public void setPlatformRefundFee(String platformRefundFee) {
			this.platformRefundFee = platformRefundFee;
		}
		public Long getPlatformRefundStatus() {
			return this.platformRefundStatus;
		}
		public void setPlatformRefundStatus(Long platformRefundStatus) {
			this.platformRefundStatus = platformRefundStatus;
		}
		public Long getPriceProtectionId() {
			return this.priceProtectionId;
		}
		public void setPriceProtectionId(Long priceProtectionId) {
			this.priceProtectionId = priceProtectionId;
		}
		public String getScene() {
			return this.scene;
		}
		public void setScene(String scene) {
			this.scene = scene;
		}
		public String getSellerRefundFee() {
			return this.sellerRefundFee;
		}
		public void setSellerRefundFee(String sellerRefundFee) {
			this.sellerRefundFee = sellerRefundFee;
		}
		public Long getSellerRefundStatus() {
			return this.sellerRefundStatus;
		}
		public void setSellerRefundStatus(Long sellerRefundStatus) {
			this.sellerRefundStatus = sellerRefundStatus;
		}

}

	/**
 * 搜索到的退款信息列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Refund extends TaobaoObject {

	private static final long serialVersionUID = 1441622685399464471L;

	/**
		 * disputeRequest ：1 是仅退款   3 是退货退款  4 是换货
		 */
		@ApiField("attribute")
		private String attribute;
		/**
		 * 买家昵称
		 */
		@ApiField("buyer_nick")
		private String buyerNick;
		/**
		 * 买家openId
		 */
		@ApiField("buyer_open_uid")
		private String buyerOpenUid;
		/**
		 * 物流公司名称
		 */
		@ApiField("company_name")
		private String companyName;
		/**
		 * 退款申请时间。格式:yyyy-MM-dd HH:mm:ss
		 */
		@ApiField("created")
		private Date created;
		/**
		 * 退款说明
		 */
		@ApiField("desc")
		private String desc;
		/**
		 * 货物状态。可选值BUYER_NOT_RECEIVED (买家未收到货) BUYER_RECEIVED (买家已收到货) BUYER_RETURNED_GOODS (买家已退货)
		 */
		@ApiField("good_status")
		private String goodStatus;
		/**
		 * 买家是否需要退货。可选值:true(是),false(否)
		 */
		@ApiField("has_good_return")
		private Boolean hasGoodReturn;
		/**
		 * 更新时间。格式:yyyy-MM-dd HH:mm:ss
		 */
		@ApiField("modified")
		private Date modified;
		/**
		 * 商品购买数量
		 */
		@ApiField("num")
		private Long num;
		/**
		 * 子订单号。如果是单笔交易oid会等于tid
		 */
		@ApiField("oid")
		private Long oid;
		/**
		 * 退款约束，可选值：cannot_refuse（不允许操作），refund_onweb（需要到网页版操作）
		 */
		@ApiField("operation_contraint")
		private String operationContraint;
		/**
		 * 退款对应的订单交易状态。可选值TRADE_NO_CREATE_PAY(没有创建支付宝交易) WAIT_BUYER_PAY(等待买家付款) WAIT_SELLER_SEND_GOODS(等待卖家发货,即:买家已付款) WAIT_BUYER_CONFIRM_GOODS(等待买家确认收货,即:卖家已发货) TRADE_BUYER_SIGNED(买家已签收,货到付款专用) TRADE_FINISHED(交易成功) TRADE_CLOSED(交易关闭) TRADE_CLOSED_BY_TAOBAO(交易被淘宝关闭) ALL_WAIT_PAY(包含：WAIT_BUYER_PAY、TRADE_NO_CREATE_PAY) ALL_CLOSED(包含：TRADE_CLOSED、TRADE_CLOSED_BY_TAOBAO) 取自&quot;http:open.taobao.comdevindex.php%E4%BA%A4%E6%98%93%E7%8A%B6%E6%80%81&quot;
		 */
		@ApiField("order_status")
		private String orderStatus;
		/**
		 * 商品外部商家编码
		 */
		@ApiField("outer_id")
		private String outerId;
		/**
		 * 支付给卖家的金额(交易总金额-退还给买家的金额)。精确到2位小数;单位:元。如:200.07，表示:200元7分
		 */
		@ApiField("payment")
		private String payment;
		/**
		 * 价保信息
		 */
		@ApiField("price_protection")
		private PriceProtection priceProtection;
		/**
		 * 收件人淘宝加密昵称
		 */
		@ApiField("real_receiver_display_nick")
		private String realReceiverDisplayNick;
		/**
		 * 收件人淘宝加密openId
		 */
		@ApiField("real_receiver_open_id")
		private String realReceiverOpenId;
		/**
		 * 退款原因
		 */
		@ApiField("reason")
		private String reason;
		/**
		 * 退还金额(退还给买家的金额)。精确到2位小数;单位:元。如:200.07，表示:200元7分
		 */
		@ApiField("refund_fee")
		private String refundFee;
		/**
		 * 退款单号
		 */
		@ApiField("refund_id")
		private Long refundId;
		/**
		 * 退款阶段，可选值：onsaleaftersale
		 */
		@ApiField("refund_phase")
		private String refundPhase;
		/**
		 * 退款版本号（时间戳）
		 */
		@ApiField("refund_version")
		private Long refundVersion;
		/**
		 * 卖家昵称
		 */
		@ApiField("seller_nick")
		private String sellerNick;
		/**
		 * 退货运单号
		 */
		@ApiField("sid")
		private String sid;
		/**
		 * 商品SKU信息
		 */
		@ApiField("sku")
		private String sku;
		/**
		 * 特殊退款类型：退差返现、价保服务
		 */
		@ApiField("special_refund_type")
		private String specialRefundType;
		/**
		 * 退款状态。可选值WAIT_SELLER_AGREE(买家已经申请退款，等待卖家同意) WAIT_BUYER_RETURN_GOODS(卖家已经同意退款，等待买家退货) WAIT_SELLER_CONFIRM_GOODS(买家已经退货，等待卖家确认收货) SELLER_REFUSE_BUYER(卖家拒绝退款) CLOSED(退款关闭) SUCCESS(退款成功)
		 */
		@ApiField("status")
		private String status;
		/**
		 * 淘宝交易单号
		 */
		@ApiField("tid")
		private Long tid;
		/**
		 * 商品标题
		 */
		@ApiField("title")
		private String title;
		/**
		 * 交易总金额。精确到2位小数;单位:元。如:200.07，表示:200元7分
		 */
		@ApiField("total_fee")
		private String totalFee;
	

	public String getAttribute() {
			return this.attribute;
		}
		public void setAttribute(String attribute) {
			this.attribute = attribute;
		}
		public String getBuyerNick() {
			return this.buyerNick;
		}
		public void setBuyerNick(String buyerNick) {
			this.buyerNick = buyerNick;
		}
		public String getBuyerOpenUid() {
			return this.buyerOpenUid;
		}
		public void setBuyerOpenUid(String buyerOpenUid) {
			this.buyerOpenUid = buyerOpenUid;
		}
		public String getCompanyName() {
			return this.companyName;
		}
		public void setCompanyName(String companyName) {
			this.companyName = companyName;
		}
		public Date getCreated() {
			return this.created;
		}
		public void setCreated(Date created) {
			this.created = created;
		}
		public String getDesc() {
			return this.desc;
		}
		public void setDesc(String desc) {
			this.desc = desc;
		}
		public String getGoodStatus() {
			return this.goodStatus;
		}
		public void setGoodStatus(String goodStatus) {
			this.goodStatus = goodStatus;
		}
		public Boolean getHasGoodReturn() {
			return this.hasGoodReturn;
		}
		public void setHasGoodReturn(Boolean hasGoodReturn) {
			this.hasGoodReturn = hasGoodReturn;
		}
		public Date getModified() {
			return this.modified;
		}
		public void setModified(Date modified) {
			this.modified = modified;
		}
		public Long getNum() {
			return this.num;
		}
		public void setNum(Long num) {
			this.num = num;
		}
		public Long getOid() {
			return this.oid;
		}
		public void setOid(Long oid) {
			this.oid = oid;
		}
		public String getOperationContraint() {
			return this.operationContraint;
		}
		public void setOperationContraint(String operationContraint) {
			this.operationContraint = operationContraint;
		}
		public String getOrderStatus() {
			return this.orderStatus;
		}
		public void setOrderStatus(String orderStatus) {
			this.orderStatus = orderStatus;
		}
		public String getOuterId() {
			return this.outerId;
		}
		public void setOuterId(String outerId) {
			this.outerId = outerId;
		}
		public String getPayment() {
			return this.payment;
		}
		public void setPayment(String payment) {
			this.payment = payment;
		}
		public PriceProtection getPriceProtection() {
			return this.priceProtection;
		}
		public void setPriceProtection(PriceProtection priceProtection) {
			this.priceProtection = priceProtection;
		}
		public String getRealReceiverDisplayNick() {
			return this.realReceiverDisplayNick;
		}
		public void setRealReceiverDisplayNick(String realReceiverDisplayNick) {
			this.realReceiverDisplayNick = realReceiverDisplayNick;
		}
		public String getRealReceiverOpenId() {
			return this.realReceiverOpenId;
		}
		public void setRealReceiverOpenId(String realReceiverOpenId) {
			this.realReceiverOpenId = realReceiverOpenId;
		}
		public String getReason() {
			return this.reason;
		}
		public void setReason(String reason) {
			this.reason = reason;
		}
		public String getRefundFee() {
			return this.refundFee;
		}
		public void setRefundFee(String refundFee) {
			this.refundFee = refundFee;
		}
		public Long getRefundId() {
			return this.refundId;
		}
		public void setRefundId(Long refundId) {
			this.refundId = refundId;
		}
		public String getRefundPhase() {
			return this.refundPhase;
		}
		public void setRefundPhase(String refundPhase) {
			this.refundPhase = refundPhase;
		}
		public Long getRefundVersion() {
			return this.refundVersion;
		}
		public void setRefundVersion(Long refundVersion) {
			this.refundVersion = refundVersion;
		}
		public String getSellerNick() {
			return this.sellerNick;
		}
		public void setSellerNick(String sellerNick) {
			this.sellerNick = sellerNick;
		}
		public String getSid() {
			return this.sid;
		}
		public void setSid(String sid) {
			this.sid = sid;
		}
		public String getSku() {
			return this.sku;
		}
		public void setSku(String sku) {
			this.sku = sku;
		}
		public String getSpecialRefundType() {
			return this.specialRefundType;
		}
		public void setSpecialRefundType(String specialRefundType) {
			this.specialRefundType = specialRefundType;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public Long getTid() {
			return this.tid;
		}
		public void setTid(Long tid) {
			this.tid = tid;
		}
		public String getTitle() {
			return this.title;
		}
		public void setTitle(String title) {
			this.title = title;
		}
		public String getTotalFee() {
			return this.totalFee;
		}
		public void setTotalFee(String totalFee) {
			this.totalFee = totalFee;
		}

}



}
