package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: tmall.dispute.receive.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TmallDisputeReceiveGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 6347714334145569667L;

	/** 
	 * result
	 */
	@ApiField("result")
	private ResultSet result;


	public void setResult(ResultSet result) {
		this.result = result;
	}
	public ResultSet getResult( ) {
		return this.result;
	}
	
	/**
 * results
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Dispute extends TaobaoObject {

	private static final long serialVersionUID = 3193338315836418764L;

	/**
		 * 卖家收货地址
		 */
		@ApiField("address")
		private String address;
		/**
		 * 支付宝单号
		 */
		@ApiField("alipay_no")
		private String alipayNo;
		/**
		 * 纠纷单上的各项属性
		 */
		@ApiField("attribute")
		private String attribute;
		/**
		 * 正向交易单号
		 */
		@ApiField("biz_order_id")
		private String bizOrderId;
		/**
		 * 买家收货地址（换货）
		 */
		@ApiField("buyer_address")
		private String buyerAddress;
		/**
		 * 买家发货物流公司（换货）
		 */
		@ApiField("buyer_logistic_name")
		private String buyerLogisticName;
		/**
		 * 买家发货物流单号（换货）
		 */
		@ApiField("buyer_logistic_no")
		private String buyerLogisticNo;
		/**
		 * 买家收货人姓名（换货）
		 */
		@ApiField("buyer_name")
		private String buyerName;
		/**
		 * 买家昵称
		 */
		@ApiField("buyer_nick")
		private String buyerNick;
		/**
		 * 买家openId
		 */
		@ApiField("buyer_open_uid")
		private String buyerOpenUid;
		/**
		 * 买家联系方式（换货）
		 */
		@ApiField("buyer_phone")
		private String buyerPhone;
		/**
		 * 卖家发货物流单号
		 */
		@ApiField("company_name")
		private String companyName;
		/**
		 * 纠纷单创建时间
		 */
		@ApiField("created")
		private Date created;
		/**
		 * 纠纷说明
		 */
		@ApiField("desc")
		private String desc;
		/**
		 * 纠纷类型，常见的有：仅退款、退货退款、换货
		 */
		@ApiField("dispute_request")
		private String disputeRequest;
		/**
		 * 买家退货时间
		 */
		@ApiField("good_return_time")
		private Date goodReturnTime;
		/**
		 * 货物状态
		 */
		@ApiField("good_status")
		private String goodStatus;
		/**
		 * 买家是否需要退货。可选值:true(是),false(否)
		 */
		@ApiField("has_good_return")
		private Boolean hasGoodReturn;
		/**
		 * 纠纷单修改时间
		 */
		@ApiField("modified")
		private Date modified;
		/**
		 * 买家购买数量
		 */
		@ApiField("num")
		private Long num;
		/**
		 * 子订单号。如果是单笔交易oid会等于tid
		 */
		@ApiField("oid")
		private Long oid;
		/**
		 * 退款对应的订单交易状态。可选值TRADE_NO_CREATE_PAY(没有创建支付宝交易) WAIT_BUYER_PAY(等待买家付款) WAIT_SELLER_SEND_GOODS(等待卖家发货,即:买家已付款) WAIT_BUYER_CONFIRM_GOODS(等待买家确认收货,即:卖家已发货) TRADE_BUYER_SIGNED(买家已签收,货到付款专用) TRADE_FINISHED(交易成功) TRADE_CLOSED(交易关闭) TRADE_CLOSED_BY_TAOBAO(交易被淘宝关闭) ALL_WAIT_PAY(包含：WAIT_BUYER_PAY、TRADE_NO_CREATE_PAY) ALL_CLOSED(包含：TRADE_CLOSED、TRADE_CLOSED_BY_TAOBAO) 取自&quot;http:open.taobao.comdevindex.php%E4%BA%A4%E6%98%93%E7%8A%B6%E6%80%81&quot;
		 */
		@ApiField("order_status")
		private String orderStatus;
		/**
		 * 收件人淘宝加密昵称
		 */
		@ApiField("real_receiver_display_nick")
		private String realReceiverDisplayNick;
		/**
		 * 收件人淘宝加密openId
		 */
		@ApiField("real_receiver_open_id")
		private String realReceiverOpenId;
		/**
		 * 退款原因
		 */
		@ApiField("reason")
		private String reason;
		/**
		 * 退还金额(退还给买家的金额)。精确到2位小数;单位:元。如:200.07，表示:200元7分
		 */
		@ApiField("refund_fee")
		private String refundFee;
		/**
		 * 纠纷单号id
		 */
		@ApiField("refund_id")
		private String refundId;
		/**
		 * 退款阶段，可选值：onsaleaftersale
		 */
		@ApiField("refund_phase")
		private String refundPhase;
		/**
		 * 卖家发货物流公司（换货）
		 */
		@ApiField("seller_logistic_name")
		private String sellerLogisticName;
		/**
		 * 卖家发货物流单号（换货）
		 */
		@ApiField("seller_logistic_no")
		private String sellerLogisticNo;
		/**
		 * 逆向纠纷状态。其中，仅退款退货退款的状态为：(1, "买家已经申请退款，等待卖家同意"),(2, "卖家已经同意退款，等待买家退货"),(3, "买家已经退货，等待卖家确认收货"),(4, "退款关闭"),(5, "退款成功"),(6, "卖家拒绝退款”),(7, "等待买家确认重新邮寄的货物"),(8, "等待卖家确认退货地址")；换货的状态为：(1, "换货待处理"),(2, "待买家退货"),(3, "买家已退货，待收货"),(4, "换货关闭"),(5, "换货成功"),(6, "待买家修改"),(12, "待发出换货商品"),(13, "待买家收货"),(14, "请退款")
		 */
		@ApiField("status")
		private String status;
		/**
		 * 超时时间
		 */
		@ApiField("time_out")
		private String timeOut;
		/**
		 * 商品名称
		 */
		@ApiField("title")
		private String title;
	

	public String getAddress() {
			return this.address;
		}
		public void setAddress(String address) {
			this.address = address;
		}
		public String getAlipayNo() {
			return this.alipayNo;
		}
		public void setAlipayNo(String alipayNo) {
			this.alipayNo = alipayNo;
		}
		public String getAttribute() {
			return this.attribute;
		}
		public void setAttribute(String attribute) {
			this.attribute = attribute;
		}
		public String getBizOrderId() {
			return this.bizOrderId;
		}
		public void setBizOrderId(String bizOrderId) {
			this.bizOrderId = bizOrderId;
		}
		public String getBuyerAddress() {
			return this.buyerAddress;
		}
		public void setBuyerAddress(String buyerAddress) {
			this.buyerAddress = buyerAddress;
		}
		public String getBuyerLogisticName() {
			return this.buyerLogisticName;
		}
		public void setBuyerLogisticName(String buyerLogisticName) {
			this.buyerLogisticName = buyerLogisticName;
		}
		public String getBuyerLogisticNo() {
			return this.buyerLogisticNo;
		}
		public void setBuyerLogisticNo(String buyerLogisticNo) {
			this.buyerLogisticNo = buyerLogisticNo;
		}
		public String getBuyerName() {
			return this.buyerName;
		}
		public void setBuyerName(String buyerName) {
			this.buyerName = buyerName;
		}
		public String getBuyerNick() {
			return this.buyerNick;
		}
		public void setBuyerNick(String buyerNick) {
			this.buyerNick = buyerNick;
		}
		public String getBuyerOpenUid() {
			return this.buyerOpenUid;
		}
		public void setBuyerOpenUid(String buyerOpenUid) {
			this.buyerOpenUid = buyerOpenUid;
		}
		public String getBuyerPhone() {
			return this.buyerPhone;
		}
		public void setBuyerPhone(String buyerPhone) {
			this.buyerPhone = buyerPhone;
		}
		public String getCompanyName() {
			return this.companyName;
		}
		public void setCompanyName(String companyName) {
			this.companyName = companyName;
		}
		public Date getCreated() {
			return this.created;
		}
		public void setCreated(Date created) {
			this.created = created;
		}
		public String getDesc() {
			return this.desc;
		}
		public void setDesc(String desc) {
			this.desc = desc;
		}
		public String getDisputeRequest() {
			return this.disputeRequest;
		}
		public void setDisputeRequest(String disputeRequest) {
			this.disputeRequest = disputeRequest;
		}
		public Date getGoodReturnTime() {
			return this.goodReturnTime;
		}
		public void setGoodReturnTime(Date goodReturnTime) {
			this.goodReturnTime = goodReturnTime;
		}
		public String getGoodStatus() {
			return this.goodStatus;
		}
		public void setGoodStatus(String goodStatus) {
			this.goodStatus = goodStatus;
		}
		public Boolean getHasGoodReturn() {
			return this.hasGoodReturn;
		}
		public void setHasGoodReturn(Boolean hasGoodReturn) {
			this.hasGoodReturn = hasGoodReturn;
		}
		public Date getModified() {
			return this.modified;
		}
		public void setModified(Date modified) {
			this.modified = modified;
		}
		public Long getNum() {
			return this.num;
		}
		public void setNum(Long num) {
			this.num = num;
		}
		public Long getOid() {
			return this.oid;
		}
		public void setOid(Long oid) {
			this.oid = oid;
		}
		public String getOrderStatus() {
			return this.orderStatus;
		}
		public void setOrderStatus(String orderStatus) {
			this.orderStatus = orderStatus;
		}
		public String getRealReceiverDisplayNick() {
			return this.realReceiverDisplayNick;
		}
		public void setRealReceiverDisplayNick(String realReceiverDisplayNick) {
			this.realReceiverDisplayNick = realReceiverDisplayNick;
		}
		public String getRealReceiverOpenId() {
			return this.realReceiverOpenId;
		}
		public void setRealReceiverOpenId(String realReceiverOpenId) {
			this.realReceiverOpenId = realReceiverOpenId;
		}
		public String getReason() {
			return this.reason;
		}
		public void setReason(String reason) {
			this.reason = reason;
		}
		public String getRefundFee() {
			return this.refundFee;
		}
		public void setRefundFee(String refundFee) {
			this.refundFee = refundFee;
		}
		public String getRefundId() {
			return this.refundId;
		}
		public void setRefundId(String refundId) {
			this.refundId = refundId;
		}
		public String getRefundPhase() {
			return this.refundPhase;
		}
		public void setRefundPhase(String refundPhase) {
			this.refundPhase = refundPhase;
		}
		public String getSellerLogisticName() {
			return this.sellerLogisticName;
		}
		public void setSellerLogisticName(String sellerLogisticName) {
			this.sellerLogisticName = sellerLogisticName;
		}
		public String getSellerLogisticNo() {
			return this.sellerLogisticNo;
		}
		public void setSellerLogisticNo(String sellerLogisticNo) {
			this.sellerLogisticNo = sellerLogisticNo;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public String getTimeOut() {
			return this.timeOut;
		}
		public void setTimeOut(String timeOut) {
			this.timeOut = timeOut;
		}
		public String getTitle() {
			return this.title;
		}
		public void setTitle(String title) {
			this.title = title;
		}

}

	/**
 * result
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ResultSet extends TaobaoObject {

	private static final long serialVersionUID = 2511265179893272247L;

	/**
		 * 错误码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 错误信息
		 */
		@ApiField("error_msg")
		private String errorMsg;
		/**
		 * 是否还有下一页
		 */
		@ApiField("has_next")
		private Boolean hasNext;
		/**
		 * 当前页面的纠纷单数量
		 */
		@ApiField("page_results")
		private Long pageResults;
		/**
		 * results
		 */
		@ApiListField("results")
		@ApiField("dispute")
		private List<Dispute> results;
		/**
		 * 所有符合查询条件的纠纷单数量
		 */
		@ApiField("total_results")
		private Long totalResults;
	

	public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getErrorMsg() {
			return this.errorMsg;
		}
		public void setErrorMsg(String errorMsg) {
			this.errorMsg = errorMsg;
		}
		public Boolean getHasNext() {
			return this.hasNext;
		}
		public void setHasNext(Boolean hasNext) {
			this.hasNext = hasNext;
		}
		public Long getPageResults() {
			return this.pageResults;
		}
		public void setPageResults(Long pageResults) {
			this.pageResults = pageResults;
		}
		public List<Dispute> getResults() {
			return this.results;
		}
		public void setResults(List<Dispute> results) {
			this.results = results;
		}
		public Long getTotalResults() {
			return this.totalResults;
		}
		public void setTotalResults(Long totalResults) {
			this.totalResults = totalResults;
		}

}



}
