package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: tmall.traderate.feeds.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TmallTraderateFeedsGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 2397777497654453125L;

	/** 
	 * 返回评价信息
	 */
	@ApiField("tmall_rate_info")
	private Model tmallRateInfo;


	public void setTmallRateInfo(Model tmallRateInfo) {
		this.tmallRateInfo = tmallRateInfo;
	}
	public Model getTmallRateInfo( ) {
		return this.tmallRateInfo;
	}
	
	/**
 * 原始评价对应的标签列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Tags extends TaobaoObject {

	private static final long serialVersionUID = 3227737951154174394L;

	/**
		 * 表示标签的极性，正极true，负极false
		 */
		@ApiField("posi")
		private Boolean posi;
		/**
		 * 表示标签的名称
		 */
		@ApiField("tag_name")
		private String tagName;
	

	public Boolean getPosi() {
			return this.posi;
		}
		public void setPosi(Boolean posi) {
			this.posi = posi;
		}
		public String getTagName() {
			return this.tagName;
		}
		public void setTagName(String tagName) {
			this.tagName = tagName;
		}

}

	/**
 * 返回评价信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Model extends TaobaoObject {

	private static final long serialVersionUID = 7216745918474231253L;

	/**
		 * 追加评价内容
		 */
		@ApiField("append_content")
		private String appendContent;
		/**
		 * 追评中是否含有负向标签
		 */
		@ApiField("append_has_negtv")
		private Boolean appendHasNegtv;
		/**
		 * 追加评价中带有的语义标签列表
		 */
		@ApiListField("append_tags")
		@ApiField("tags")
		private List<Tags> appendTags;
		/**
		 * 追加评价时间
		 */
		@ApiField("append_time")
		private Date appendTime;
		/**
		 * 评价时间
		 */
		@ApiField("comment_time")
		private Date commentTime;
		/**
		 * 评价内容
		 */
		@ApiField("content")
		private String content;
		/**
		 * 原始评价是否含有负向标签
		 */
		@ApiField("has_negtv")
		private Boolean hasNegtv;
		/**
		 * ouid
		 */
		@ApiField("ouid")
		private String ouid;
		/**
		 * 原始评价对应的标签列表
		 */
		@ApiListField("tags")
		@ApiField("tags")
		private List<Tags> tags;
		/**
		 * 表示评价者的昵称
		 */
		@ApiField("user_nick")
		private String userNick;
	

	public String getAppendContent() {
			return this.appendContent;
		}
		public void setAppendContent(String appendContent) {
			this.appendContent = appendContent;
		}
		public Boolean getAppendHasNegtv() {
			return this.appendHasNegtv;
		}
		public void setAppendHasNegtv(Boolean appendHasNegtv) {
			this.appendHasNegtv = appendHasNegtv;
		}
		public List<Tags> getAppendTags() {
			return this.appendTags;
		}
		public void setAppendTags(List<Tags> appendTags) {
			this.appendTags = appendTags;
		}
		public Date getAppendTime() {
			return this.appendTime;
		}
		public void setAppendTime(Date appendTime) {
			this.appendTime = appendTime;
		}
		public Date getCommentTime() {
			return this.commentTime;
		}
		public void setCommentTime(Date commentTime) {
			this.commentTime = commentTime;
		}
		public String getContent() {
			return this.content;
		}
		public void setContent(String content) {
			this.content = content;
		}
		public Boolean getHasNegtv() {
			return this.hasNegtv;
		}
		public void setHasNegtv(Boolean hasNegtv) {
			this.hasNegtv = hasNegtv;
		}
		public String getOuid() {
			return this.ouid;
		}
		public void setOuid(String ouid) {
			this.ouid = ouid;
		}
		public List<Tags> getTags() {
			return this.tags;
		}
		public void setTags(List<Tags> tags) {
			this.tags = tags;
		}
		public String getUserNick() {
			return this.userNick;
		}
		public void setUserNick(String userNick) {
			this.userNick = userNick;
		}

}



}
