package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.traderates.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TraderatesGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 6696717752663931498L;

	/** 
	 * 当使用use_has_next时返回信息，如果还有下一页则返回true
	 */
	@ApiField("has_next")
	private Boolean hasNext;

	/** 
	 * 搜索到的评价总数。相同的查询时间段条件下，最大只能获取总共1500条评价记录。所以当评价大于等于1500时 ISV可以通过start_date及end_date来进行拆分，以保证可以查询到全部数据
	 */
	@ApiField("total_results")
	private Long totalResults;

	/** 
	 * 评价列表。返回的TradeRate包含的具体信息为入参fields请求的字段信息
	 */
	@ApiListField("trade_rates")
	@ApiField("trade_rate")
	private List<Results> tradeRates;


	public void setHasNext(Boolean hasNext) {
		this.hasNext = hasNext;
	}
	public Boolean getHasNext( ) {
		return this.hasNext;
	}

	public void setTotalResults(Long totalResults) {
		this.totalResults = totalResults;
	}
	public Long getTotalResults( ) {
		return this.totalResults;
	}

	public void setTradeRates(List<Results> tradeRates) {
		this.tradeRates = tradeRates;
	}
	public List<Results> getTradeRates( ) {
		return this.tradeRates;
	}
	
	/**
 * 评价列表。返回的TradeRate包含的具体信息为入参fields请求的字段信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Results extends TaobaoObject {

	private static final long serialVersionUID = 1778116414189861582L;

	/**
		 * 评价内容,最大长度:500个汉字
		 */
		@ApiField("content")
		private String content;
		/**
		 * 评价创建时间,格式:yyyy-MM-dd HH:mm:ss
		 */
		@ApiField("created")
		private Date created;
		/**
		 * 商品价格,精确到2位小数;单位:元.如:200.07，表示:200元7分
		 */
		@ApiField("item_price")
		private String itemPrice;
		/**
		 * 商品标题
		 */
		@ApiField("item_title")
		private String itemTitle;
		/**
		 * 物流服务评分
		 */
		@ApiField("logistics_service_score")
		private Long logisticsServiceScore;
		/**
		 * 评价者昵称
		 */
		@ApiField("nick")
		private String nick;
		/**
		 * 商品的数字ID
		 */
		@ApiField("num_iid")
		private Long numIid;
		/**
		 * 子订单ID
		 */
		@ApiField("oid")
		private Long oid;
		/**
		 * ouid
		 */
		@ApiField("ouid")
		private String ouid;
		/**
		 * 被评价者昵称
		 */
		@ApiField("rated_nick")
		private String ratedNick;
		/**
		 * 评价解释,最大长度:500个汉字
		 */
		@ApiField("reply")
		private String reply;
		/**
		 * 评价结果,可选值:good(好评),neutral(中评),bad(差评)
		 */
		@ApiField("result")
		private String result;
		/**
		 * 评价者角色.可选值:seller(卖家),buyer(买家)
		 */
		@ApiField("role")
		private String role;
		/**
		 * 交易ID
		 */
		@ApiField("tid")
		private Long tid;
		/**
		 * 评价信息是否用于记分，
	可取值：true(参与记分)和false(不参与记分)
		 */
		@ApiField("valid_score")
		private Boolean validScore;
	

	public String getContent() {
			return this.content;
		}
		public void setContent(String content) {
			this.content = content;
		}
		public Date getCreated() {
			return this.created;
		}
		public void setCreated(Date created) {
			this.created = created;
		}
		public String getItemPrice() {
			return this.itemPrice;
		}
		public void setItemPrice(String itemPrice) {
			this.itemPrice = itemPrice;
		}
		public String getItemTitle() {
			return this.itemTitle;
		}
		public void setItemTitle(String itemTitle) {
			this.itemTitle = itemTitle;
		}
		public Long getLogisticsServiceScore() {
			return this.logisticsServiceScore;
		}
		public void setLogisticsServiceScore(Long logisticsServiceScore) {
			this.logisticsServiceScore = logisticsServiceScore;
		}
		public String getNick() {
			return this.nick;
		}
		public void setNick(String nick) {
			this.nick = nick;
		}
		public Long getNumIid() {
			return this.numIid;
		}
		public void setNumIid(Long numIid) {
			this.numIid = numIid;
		}
		public Long getOid() {
			return this.oid;
		}
		public void setOid(Long oid) {
			this.oid = oid;
		}
		public String getOuid() {
			return this.ouid;
		}
		public void setOuid(String ouid) {
			this.ouid = ouid;
		}
		public String getRatedNick() {
			return this.ratedNick;
		}
		public void setRatedNick(String ratedNick) {
			this.ratedNick = ratedNick;
		}
		public String getReply() {
			return this.reply;
		}
		public void setReply(String reply) {
			this.reply = reply;
		}
		public String getResult() {
			return this.result;
		}
		public void setResult(String result) {
			this.result = result;
		}
		public String getRole() {
			return this.role;
		}
		public void setRole(String role) {
			this.role = role;
		}
		public Long getTid() {
			return this.tid;
		}
		public void setTid(Long tid) {
			this.tid = tid;
		}
		public Boolean getValidScore() {
			return this.validScore;
		}
		public void setValidScore(Boolean validScore) {
			this.validScore = validScore;
		}

}



}
