/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.tmc;

import com.tydic.tmc.constant.BusinessCode;
import com.tydic.tmc.exception.BaseException;
import java.io.Serializable;

public class ResultData<T>
implements Serializable {
    private static final long serialVersionUID = 7671885796496392430L;
    private String code;
    private String message;
    private T data;

    public ResultData() {
    }

    public ResultData(BusinessCode businessCode, T data) {
        if (businessCode != null) {
            this.setCode(businessCode.getCode());
            this.setMessage(businessCode.getMessage());
        }
        this.data = data;
    }

    public ResultData(BusinessCode businessCode) {
        if (businessCode != null) {
            this.setCode(businessCode.getCode());
            this.setMessage(businessCode.getMessage());
        }
    }

    public ResultData(String errorCode, String errorTips) {
        this.setCode(errorCode);
        this.setMessage(errorTips);
    }

    public ResultData(String message) {
        this.setCode(BusinessCode.FAILD.getCode());
        this.setMessage(message);
    }

    public static <T> ResultData<T> success(T data) {
        return new ResultData<T>(BusinessCode.SUCCESS, data);
    }

    public static <T> ResultData<T> success() {
        return new ResultData<T>(BusinessCode.SUCCESS);
    }

    public static <T> ResultData<T> fail(BusinessCode codeMsg) {
        return new ResultData<T>(codeMsg);
    }

    public static <T> ResultData<T> fail(BusinessCode codeMsg, String message) {
        ResultData<T> resultData = new ResultData<T>(codeMsg);
        resultData.setMessage(message);
        return resultData;
    }

    public static <T> ResultData<T> fail(BusinessCode businessCode, T data) {
        return new ResultData<T>(businessCode, data);
    }

    public static <T> ResultData<T> fail(String message) {
        return new ResultData<T>(message);
    }

    public static ResultData<Object> fail(String errorCode, String message) {
        return new ResultData<Object>(errorCode, message);
    }

    public static ResultData<Object> fail(BaseException ex) {
        return new ResultData<Object>(ex.getErrorCode(), ex.getErrorTips());
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
        this.setCode(BusinessCode.SUCCESS.getCode());
        this.setMessage(BusinessCode.SUCCESS.getMessage());
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}

