/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.tmc.aspect;

import com.google.gson.Gson;
import com.tydic.tmc.aspect.WebLog;
import com.tydic.tmc.utils.IDUtils;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class WebLogAspect {
    private static final Logger log = LoggerFactory.getLogger(WebLogAspect.class);
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String TRACE_ID = "traceId";
    @Resource
    private IDUtils idUtils;

    @Pointcut(value="@annotation(com.tydic.tmc.aspect.WebLog)")
    public void webLog() {
    }

    @Before(value="webLog()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        MDC.put((String)TRACE_ID, (String)this.idUtils.generateTraceId());
        String methodDescription = this.getAspectLogDescription(joinPoint);
        log.info("========== \u8bf7\u6c42\u5f00\u59cb: [{}], \u5165\u53c2: {} =================================== ", (Object)methodDescription, (Object)this.toJson(joinPoint));
        log.info("\u8bf7\u6c42\u7684\u7c7b: {}, \u65b9\u6cd5: {}", (Object)joinPoint.getSignature().getDeclaringTypeName(), (Object)joinPoint.getSignature().getName());
    }

    @After(value="webLog()")
    public void doAfter() throws Throwable {
    }

    @Around(value="webLog()")
    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object result = proceedingJoinPoint.proceed();
        long timeConsuming = System.currentTimeMillis() - startTime;
        String methodDescription = this.getAspectLogDescription((JoinPoint)proceedingJoinPoint);
        log.info("========== \u8bf7\u6c42\u7ed3\u675f: [{}], \u8017\u65f6: {}ms, \u51fa\u53c2: {} =================================== {}", new Object[]{methodDescription, timeConsuming, new Gson().toJson(result), LINE_SEPARATOR});
        return result;
    }

    private String getAspectLogDescription(JoinPoint joinPoint) throws Exception {
        String targetName = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] arguments = joinPoint.getArgs();
        Class<?> targetClass = Class.forName(targetName);
        Method[] methods = targetClass.getMethods();
        StringBuilder description = new StringBuilder("");
        for (Method method : methods) {
            Class<?>[] clazzs;
            if (!method.getName().equals(methodName) || (clazzs = method.getParameterTypes()).length != arguments.length) continue;
            description.append(method.getAnnotation(WebLog.class).description());
            break;
        }
        return description.toString();
    }

    private String toJson(JoinPoint joinPoint) {
        return new Gson().toJson((Object)joinPoint.getArgs());
    }
}

