/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.tmc.common;

import java.io.Serializable;

public class CurrencyVO
implements Serializable {
    private String code = "CNY";
    private String value = "0.00";
    private int fixedValue = 0;
    private int decimalCount = 2;

    public void setDoubleValue(Double value) {
        this.value = String.format("%.02f", value);
        this.setFixedValue((int)Math.ceil(value * Math.pow(10.0, this.decimalCount)));
    }

    public void setIntValue(Integer value) {
        Double price = (double)value.intValue() / 100.0;
        this.setDoubleValue(price);
    }

    public void setLongValue(Long value) {
        Double price = (double)value.longValue() / 100.0;
        this.setDoubleValue(price);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getFixedValue() {
        return this.fixedValue;
    }

    public void setFixedValue(int fixedValue) {
        this.fixedValue = fixedValue;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public double getDoubleValue() {
        return Double.valueOf(this.value);
    }

    public int getDecimalCount() {
        return this.decimalCount;
    }

    public void setDecimalCount(int decimalCount) {
        this.decimalCount = decimalCount;
    }

    public String toString() {
        return "CurrencyVM{code='" + this.code + '\'' + ", fixedValue=" + this.fixedValue + ", value='" + this.value + '\'' + ", decimalCount=" + this.decimalCount + '}';
    }

    public CurrencyVO(String value) {
        this.value = value;
    }

    public CurrencyVO() {
    }

    public CurrencyVO(Integer value) {
        this.setIntValue(value);
    }

    public CurrencyVO(Long value) {
        this.setLongValue(value);
    }
}

