/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.tmc.utils;

import com.tydic.tmc.utils.DateConverter;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;

public class BeanCopyUtil
extends BeanUtils {
    public static <S, T> List<T> copyListProperties(List<S> sources, Supplier<T> target) {
        return BeanCopyUtil.copyListProperties(sources, target, null);
    }

    public static <S, T> List<T> copyListProperties(List<S> sources, Supplier<T> target, BeanCopyUtilCallBack<S, T> callBack) {
        ArrayList<T> list = new ArrayList<T>(sources.size());
        for (S source : sources) {
            T t = target.get();
            try {
                BeanCopyUtil.copyProperties(t, source);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            list.add(t);
            if (callBack == null) continue;
            callBack.callBack(source, t);
        }
        return list;
    }

    public static void copy(Object source, Object target) {
        ConvertUtils.register((Converter)new DateConverter(), LocalDate.class);
        try {
            BeanCopyUtil.copyProperties((Object)source, (Object)target);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @FunctionalInterface
    public static interface BeanCopyUtilCallBack<S, T> {
        public void callBack(S var1, T var2);
    }
}

