/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.tmc.utils;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DateUtil {
    public static final String YYYYMMDDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDDHHMM = "yyyy-MM-dd HH:mm";
    public static final String YYYYMMDDHHMMSSSSS = "yyyy-MM-dd HH:mm:ss SSS";
    public static final String yyyyMMddHHmmssSSS = "yyyyMMddHHmmssSSS";
    public static final String YYYYMMDD = "yyyy-MM-dd";
    public static final String yyyyMMdd = "yyyyMMdd";
    public static final String yyyyMMddHHmmss = "yyyyMMddHHmmss";
    public static final String yyyyMMddHH = "yyyyMMddHH";
    public static final String yyyyMMddHHmm = "yyyyMMddHHmm";
    public static final String HHmmss = "HH:mm:ss";
    public static final String HHmm = "HH:mm";
    public static final String yyyyMMddEHHmm = "yyyy-MM-dd E HH:mm";

    public static Date getWeeHours(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date zero = calendar.getTime();
        return zero;
    }

    public static Date formatDateStrToDate(String strDate, String formatStr) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(formatStr);
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(strDate, pos);
        return date;
    }

    public static String formatDate(Date date, String formatStr) {
        SimpleDateFormat formatDate = new SimpleDateFormat(formatStr);
        String resultTime = formatDate.format(date);
        return resultTime;
    }

    public static String dateToDatetimeStr(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(YYYYMMDDHHMMSS);
        String dataStr = format.format((Object)date);
        return dataStr;
    }

    public static String dateToDateStr(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(YYYYMMDD);
        String dataStr = format.format((Object)date);
        return dataStr;
    }

    public static String dateToDateTimeStr(LocalDateTime localDateTime, String formatStr) {
        if (null == localDateTime) {
            return null;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern(formatStr, Locale.CHINESE);
        String localTime = df.format(localDateTime);
        return localTime;
    }

    public static Date datetimeStrToDate(String strDate) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(YYYYMMDDHHMMSS);
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(strDate, pos);
        return date;
    }

    public static Date dateStrToDate(String strDate) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(YYYYMMDD);
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(strDate, pos);
        return date;
    }

    public static LocalDateTime dateStrToLocalDateTime(String strDate, String formatStr) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern(formatStr);
        LocalDateTime localDateTime = LocalDateTime.parse(strDate, df);
        return localDateTime;
    }

    public static String localDateTimeToDateStr(LocalDateTime strDate, String formatStr) {
        if (Objects.isNull(strDate)) {
            return null;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern(formatStr);
        String localTime = df.format(strDate);
        return localTime;
    }

    public static String localDateTimeToDateStr(LocalDate date, String formatStr) {
        if (Objects.isNull(date)) {
            return null;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern(formatStr);
        String localTime = df.format(date);
        return localTime;
    }

    public static String localTimeToDateStr(LocalTime localTime, String formatStr) {
        if (Objects.isNull(localTime)) {
            return null;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern(formatStr);
        String strLocalTime = df.format(localTime);
        return strLocalTime;
    }

    public static Date getDate(Date date, Integer days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (days != null) {
            calendar.add(5, days);
        }
        return calendar.getTime();
    }

    public static String getElapsedTime(LocalDateTime from, LocalDateTime to) {
        long minutes = ChronoUnit.MINUTES.between(from, to);
        String elapsedTime = minutes / 60L + "h" + minutes % 60L + "m";
        return elapsedTime;
    }

    public static long getElapsedDate(LocalDate from, LocalDate to) {
        long days = ChronoUnit.DAYS.between(from, to);
        return days;
    }

    public static void main(String[] args) {
        LocalDateTime from = LocalDateTime.of(2020, 10, 4, 10, 20, 55);
        LocalDateTime to = LocalDateTime.of(2020, 10, 10, 10, 24, 34);
        long minutes = ChronoUnit.MINUTES.between(from, to);
        System.out.println(minutes / 60L + "h" + minutes % 60L + "m");
    }
}

