/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.tmc.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    private static final String XLS = "xls";
    private static final String XLSX = "xlsx";
    private static final DateFormat FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public static void writeDataToTemplateOutputStream(File excelTemplate, List<List<Object>> data, OutputStream outputStream) throws IOException {
        Workbook book = ExcelUtils.getWorkbookFromExcel(excelTemplate);
        ExcelUtils.writeDataToWorkbook(null, data, book, 0);
        ExcelUtils.writeWorkbookToOutputStream(book, outputStream);
    }

    public static Workbook getWorkbookFromExcel(File excelFile) throws IOException {
        Throwable throwable = null;
        try (FileInputStream inputStream = new FileInputStream(excelFile);){
            if (excelFile.getName().endsWith(XLS)) {
                HSSFWorkbook hSSFWorkbook = new HSSFWorkbook((InputStream)inputStream);
                return hSSFWorkbook;
            }
            if (excelFile.getName().endsWith(XLSX)) {
                XSSFWorkbook xSSFWorkbook = new XSSFWorkbook((InputStream)inputStream);
                return xSSFWorkbook;
            }
            try {
                throw new IOException("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static void writeWorkbookToFile(Workbook book, File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            ExcelUtils.writeWorkbookToOutputStream(book, outputStream);
        }
    }

    public static void writeWorkbookToOutputStream(Workbook book, OutputStream outputStream) throws IOException {
        book.write(outputStream);
    }

    public static void writeDataToWorkbook(List<String> title, List<List<Object>> data, Workbook book, int page) {
        Sheet sheet = book.getSheetAt(page);
        Row row = null;
        Cell cell = null;
        if (null != title && !title.isEmpty()) {
            row = sheet.getRow(0);
            if (null == row) {
                row = sheet.createRow(0);
            }
            for (int i = 0; i < title.size(); ++i) {
                cell = row.getCell(i);
                if (null == cell) {
                    cell = row.createCell(i);
                }
                cell.setCellValue(title.get(i));
            }
        }
        List<Object> rowData = null;
        for (int i = 0; i < data.size(); ++i) {
            row = sheet.getRow(i + 1);
            if (null == row) {
                row = sheet.createRow(i + 1);
            }
            if (null == (rowData = data.get(i))) continue;
            for (int j = 0; j < rowData.size(); ++j) {
                cell = row.getCell(j);
                if (null == cell) {
                    cell = row.createCell(j);
                }
                ExcelUtils.setValue(cell, rowData.get(j));
            }
        }
    }

    public static List<List<Object>> readExcelFirstSheet(String pathname) throws IOException {
        File file = new File(pathname);
        return ExcelUtils.readExcelFirstSheet(file);
    }

    public static List<List<Object>> readExcelFirstSheet(File file) throws IOException {
        Throwable throwable = null;
        try (FileInputStream inputStream = new FileInputStream(file);){
            if (file.getName().endsWith(XLS)) {
                List<List<Object>> list = ExcelUtils.readXlsFirstSheet(inputStream);
                return list;
            }
            if (file.getName().endsWith(XLSX)) {
                List<List<Object>> list = ExcelUtils.readXlsxFirstSheet(inputStream);
                return list;
            }
            try {
                throw new IOException("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static List<List<Object>> readXlsFirstSheet(InputStream inputStream) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook(inputStream);
        return ExcelUtils.readExcelFirstSheet((Workbook)workbook);
    }

    public static List<List<Object>> readXlsxFirstSheet(InputStream inputStream) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        return ExcelUtils.readExcelFirstSheet((Workbook)workbook);
    }

    public static List<List<Object>> readExcelFirstSheet(Workbook book) {
        return ExcelUtils.readExcel(book, 0);
    }

    public static List<List<Object>> readExcel(Workbook book, int page) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        Sheet sheet = book.getSheetAt(page);
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (null == row) {
                list.add(null);
                continue;
            }
            ArrayList<Object> columns = new ArrayList<Object>();
            for (int j = 0; j < row.getLastCellNum(); ++j) {
                Cell cell = row.getCell(j);
                columns.add(ExcelUtils.getValue(cell));
            }
            list.add(columns);
        }
        return list;
    }

    private static Object getValue(Cell cell) {
        if (null == cell) {
            return null;
        }
        Object value = null;
        switch (cell.getCellType()) {
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = cell.getDateCellValue();
                    break;
                }
                value = new BigDecimal(cell.getNumericCellValue());
                break;
            }
            default: {
                value = cell.toString();
            }
        }
        return value;
    }

    private static void setValue(Cell cell, Object value) {
        if (null == cell) {
            return;
        }
        if (null == value) {
            cell.setCellValue((String)null);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Date) {
            cell.setCellValue(FORMAT.format((Date)value));
        } else if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else {
            cell.setCellValue(value.toString());
        }
    }
}

