/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.tmc.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonUtil {
    private static final Logger log = LoggerFactory.getLogger(GsonUtil.class);
    private static final GsonUtil INSTANCE = new GsonUtil();
    private static final Gson GSON = new Gson();

    public static GsonUtil getInstance() {
        return INSTANCE;
    }

    public String toJson(Object object) {
        return GSON.toJson(object);
    }

    public <T> T fromJson(String json, Class<T> tClass) {
        return (T)GSON.fromJson(json, tClass);
    }

    public static <T> List<T> fromList(String string, Class<T[]> cls) {
        Gson gson = new Gson();
        Object[] array = (Object[])gson.fromJson(string, cls);
        return Arrays.asList(array);
    }

    public String toGetParam(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return "";
        }
        Map<String, String> map = this.toStringMap(json);
        StringBuilder stringBuilder = new StringBuilder();
        map.forEach((k, v) -> stringBuilder.append((String)k).append("=").append((String)v).append("&"));
        String r = stringBuilder.toString();
        return r.substring(0, r.lastIndexOf("&"));
    }

    public Map<String, String> toStringMap(String json) {
        return (Map)GSON.fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
    }

    public List<Map> toListMap(String json) {
        return (List)GSON.fromJson(json, new TypeToken<List<Map>>(){}.getType());
    }

    public Map<String, Object> toObjectMap(String json) {
        TypeToken<Map<String, Object>> typeToken = new TypeToken<Map<String, Object>>(){};
        Gson gson = new GsonBuilder().serializeNulls().registerTypeHierarchyAdapter(typeToken.getRawType(), new MapDeserializer()).create();
        return (Map)gson.fromJson(json, typeToken.getType());
    }

    private class MapDeserializer<T, U>
    implements JsonDeserializer<Map<T, U>> {
        private MapDeserializer() {
        }

        public Map<T, U> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                return null;
            }
            JsonObject jsonObject = json.getAsJsonObject();
            Set jsonEntrySet = jsonObject.entrySet();
            LinkedHashMap deserializedMap = new LinkedHashMap();
            for (Map.Entry entry : jsonEntrySet) {
                Object value = context.deserialize((JsonElement)entry.getValue(), (Type)this.getType((JsonElement)entry.getValue()));
                deserializedMap.put(entry.getKey(), value);
            }
            return deserializedMap;
        }

        public Class getType(JsonElement element) {
            if (element.isJsonPrimitive()) {
                JsonPrimitive primitive = element.getAsJsonPrimitive();
                if (primitive.isString()) {
                    return String.class;
                }
                if (primitive.isNumber()) {
                    String numStr = primitive.getAsString();
                    if (numStr.contains(".") || numStr.contains("e") || numStr.contains("E")) {
                        return Double.class;
                    }
                    return Long.class;
                }
                if (primitive.isBoolean()) {
                    return Boolean.class;
                }
            }
            return element.getClass();
        }
    }
}

