package com.tydic.train.service.ly.task;

import com.tydic.train.service.ly.task.bo.TrainLYTaskInstListRspBO;
import com.tydic.train.service.ly.task.bo.TrainLYTaskInstReqBO;
import com.tydic.train.service.ly.task.bo.TrainLYTaskInstRspBO;

import java.util.List;

/**
 * 标题：TrainLYTaskInstService
 * 说明：
 * 时间： 2023-08-30 17:01
 * 作者 @author LY
 */
public interface TrainLYTaskInstService {
    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: TrainLYTaskInstReqBO
     * @return: TrainLYTaskInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYTaskInstRspBO queryTrainTaskInstSingle(TrainLYTaskInstReqBO reqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: TrainLYTaskInstReqBO
     * @return: TrainLYTaskInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYTaskInstListRspBO queryTrainTaskInstList(TrainLYTaskInstReqBO reqBO);


    /**
     * 描述:新增信息
     *
     * @throws
     * @param: TrainLYTaskInstReqBO
     * @return: TrainLYTaskInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYTaskInstRspBO addTrainTaskInst(TrainLYTaskInstReqBO reqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: TrainLYTaskInstReqBO
     * @return: TrainLYTaskInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYTaskInstListRspBO addListTrainTaskInst(List<TrainLYTaskInstReqBO> reqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: TrainLYTaskInstReqBO
     * @return: TrainLYTaskInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYTaskInstRspBO updateTrainTaskInst(TrainLYTaskInstReqBO reqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: TrainLYTaskInstReqBO
     * @return: TrainLYTaskInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYTaskInstRspBO saveTrainTaskInst(TrainLYTaskInstReqBO reqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: TrainLYTaskInstReqBO
     * @return: TrainLYTaskInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYTaskInstRspBO deleteTrainTaskInst(TrainLYTaskInstReqBO reqBO);
}
