package com.tydic.train.service.ly.task;

import com.tydic.train.service.ly.task.bo.TrainLYProcessInstListRspBO;
import com.tydic.train.service.ly.task.bo.TrainLYProcessInstReqBO;
import com.tydic.train.service.ly.task.bo.TrainLYProcessInstRspBO;

import java.util.List;

/**
 * 标题：TrainProcessInstService
 * 说明：
 * 时间： 2023-08-30 17:03
 * 作者 @author LY
 */
public interface TrainProcessInstService {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: TrainLYProcessInstReqBO
     * @return: TrainLYProcessInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYProcessInstRspBO queryTrainProcessInstSingle(TrainLYProcessInstReqBO reqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: TrainLYProcessInstReqBO
     * @return: TrainLYProcessInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYProcessInstListRspBO queryTrainProcessInstList(TrainLYProcessInstReqBO reqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: TrainLYProcessInstReqBO
     * @return: TrainLYProcessInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYProcessInstRspBO addTrainProcessInst(TrainLYProcessInstReqBO reqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: TrainLYProcessInstReqBO
     * @return: TrainLYProcessInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYProcessInstListRspBO addListTrainProcessInst(List<TrainLYProcessInstReqBO> reqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: TrainLYProcessInstReqBO
     * @return: TrainLYProcessInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYProcessInstRspBO updateTrainProcessInst(TrainLYProcessInstReqBO reqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: TrainLYProcessInstReqBO
     * @return: TrainLYProcessInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYProcessInstRspBO saveTrainProcessInst(TrainLYProcessInstReqBO reqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: TrainLYProcessInstReqBO
     * @return: TrainLYProcessInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYProcessInstRspBO deleteTrainProcessInst(TrainLYProcessInstReqBO reqBO);
}
