package com.tydic.train.service.ly.ship;


import com.tydic.train.service.ly.ship.bo.TrainYyfShipOrderListRspBO;
import com.tydic.train.service.ly.ship.bo.TrainYyfShipOrderReqBO;
import com.tydic.train.service.ly.ship.bo.TrainYyfShipOrderRspBO;

import java.util.List;

/**
 * 描述：发货单表
 *
 * @author: zhoulu
 * @date: 2023-08-31 10:37:46
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface TrainYyfShipOrderService {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    TrainYyfShipOrderRspBO queryTrainShipOrderSingle(TrainYyfShipOrderReqBO reqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    TrainYyfShipOrderListRspBO queryTrainShipOrderList(TrainYyfShipOrderReqBO reqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    TrainYyfShipOrderRspBO addTrainShipOrder(TrainYyfShipOrderReqBO reqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    TrainYyfShipOrderListRspBO addListTrainShipOrder(List<TrainYyfShipOrderReqBO> TrainYyfShipOrderReqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    TrainYyfShipOrderRspBO updateTrainShipOrder(TrainYyfShipOrderReqBO reqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    TrainYyfShipOrderRspBO saveTrainShipOrder(TrainYyfShipOrderReqBO reqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    TrainYyfShipOrderRspBO deleteTrainShipOrder(TrainYyfShipOrderReqBO reqBO);

}

