package com.tydic.train.constants;

/**
 * 常量配置类
 */
public class TrainHWRspConstant {
    public static final String SUCCESS_CODE = "0";
    public static final String SUCCESS_DESC = "成功";

    /**
     * 订单删除状态
     */
    public static class ORDER_DEL_STATE {
        /**
         * 已删除
         */
        public static final Integer DEL = 1;
        /**
         * 未删除
         */
        public static final Integer ACTIVATION = 0;
    }

    /**
     * 用户删除状态
     */
    public static class USER_DEL_STATE {
        /**
         * 已删除
         */
        public static final Integer DEL = 1;
        /**
         * 未删除
         */
        public static final Integer ACTIVATION = 0;
    }


    /**
     * 流程环节状态
     */
    public static class PROSECC_TASK_STATE {
        /**
         * 待处理
         */
        public static final Integer wait = 0;
        /**
         * 已处理
         */
        public static final Integer done = 1;
    }

    /**
     * 审批结果
     */
    public static class AUDIT_RESULT_FLAG {
        /**
         * 成功 通过
         */
        public static final Integer pass = 0;
        /**
         * 失败 驳回
         */
        public static final Integer reject = 1;
    }

    /**
     * 订单状态 1：待确认 2：待支付 3：待发货 4：已发货
     */
    public static class ORDER_STATUS {
        /**
         * 审核中
         */
        public static final Integer PENDING_REVIEW = 0;
        /**
         * 待确认
         */
        public static final Integer TO_BE_CONFIRMED = 1;
        /**
         * 待支付
         */
        public static final Integer TO_BE_PAID = 2;
        /**
         * 待发货
         */
        public static final Integer TO_BE_SHIPPED = 3;
        /**
         * 已发货
         */
        public static final Integer SHIPPED = 4;
    }

    /**
     * 订单状态
     */
    public enum OrderStatusEnum {
        PENDING_REVIEW(0,"审核中"),
        TO_BE_CONFIRMED(1, "待确认"),
        TO_BE_PAID(2, "待支付"),
        TO_BE_SHIPPED(3, "待发货"),
        SHIPPED(4, "已发货");

        private final int status;
        private final String translation;

        OrderStatusEnum(int status, String translation) {
            this.status = status;
            this.translation = translation;
        }

        public int getStatus() {
            return status;
        }

        public String getTranslation() {
            return translation;
        }

        public static String getTranslation(int status) {
            for (OrderStatusEnum orderStatus : OrderStatusEnum.values()) {
                if (orderStatus.getStatus() == status) {
                    return orderStatus.getTranslation();
                }
            }
            return "";
        }
    }

}
