package com.tydic.train.service.ly.ship;

import com.tydic.train.service.ly.ship.bo.TrainYyfShipOrderItemListRspBO;
import com.tydic.train.service.ly.ship.bo.TrainYyfShipOrderItemReqBO;
import com.tydic.train.service.ly.ship.bo.TrainYyfShipOrderItemRspBO;

import java.util.List;

/**
 * 类名：TrainYyfShipOrderItemService
 * 标题：
 * 说明：
 * 时间：2023/8/31 10:33
 *
 * @author yangyf
 **/
public interface TrainYyfShipOrderItemService {
    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    TrainYyfShipOrderItemRspBO queryTrainShipOrderItemSingle(TrainYyfShipOrderItemReqBO reqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    TrainYyfShipOrderItemListRspBO queryTrainShipOrderItemList(TrainYyfShipOrderItemReqBO reqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    TrainYyfShipOrderItemRspBO addTrainShipOrderItem(TrainYyfShipOrderItemReqBO reqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    TrainYyfShipOrderItemListRspBO addListTrainShipOrderItem(List<TrainYyfShipOrderItemReqBO> reqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    TrainYyfShipOrderItemRspBO updateTrainShipOrderItem(TrainYyfShipOrderItemReqBO reqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    TrainYyfShipOrderItemRspBO saveTrainShipOrderItem(TrainYyfShipOrderItemReqBO reqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    TrainYyfShipOrderItemRspBO deleteTrainShipOrderItem(TrainYyfShipOrderItemReqBO reqBO);

}
