package com.tydic.train.service.order.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author Hanwei
 * @version 1.0
 * @Desc TrainHWOrderCreateReqBO
 * @ClassName TrainHWOrderCreateReqBO
 * @date 2023/8/28 15:58
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TrainHWOrderCreateReqBO extends BaseReqBo {
    private static final long serialVersionUID = 4844471896995870540L;
    /**
     * 订单id
     */
    private Long orderId;
    /**
     * 订单编号
     */
    private String orderNo;
    /**
     * 订单名称
     */
    private String orderName;
    /**
     * 订单总金额
     */
    private BigDecimal orderMoney;
    /**
     * 创建人ID
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 商品信息
     */
    private List<TrainHWOrderCreateSkuBO> skuList;
}
