package com.tydic.train.service.tfquoc.constants;

import lombok.Getter;

/**
 * 标题 TrainTfqOrderStatusEnum
 * 说明 订单状态
 * 时间 2023/8/29 17:08
 *
 * @author 唐富强
 */
public enum TrainTfqOrderStatusEnum {

    TBC (1,"待确认"),
    TO_BE_PAID(2,"待支付"),
    WAITDELIVER(3,"待发货"),
    SHIPPED(4,"已发货"),
    CANCEL(5,"已取消");

    @Getter
    private Integer status;

    @Getter
    private String statusStr;

    TrainTfqOrderStatusEnum(Integer status, String statusStr) {
        this.status = status;
        this.statusStr = statusStr;
    }

    /**
     * 状态翻译
     * @param status
     * @return
     */
    public static String getStatusStr(Integer status) {
        TrainTfqOrderStatusEnum[] values = TrainTfqOrderStatusEnum.values();
        for (TrainTfqOrderStatusEnum statusEnum : values) {
            if (statusEnum.getStatus().equals(status)) {
                return statusEnum.getStatusStr();
            }
        }
        return null;
    }


}
