package com.tydic.train.constants;

import lombok.Getter;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/30 13:51
 */
public enum TrainOrderStatusEnum {

    /**
     * 订单状态
     */
    O_000(0, "订单审核中"),
    O_001(1, "待确认"),
    O_002(2, "待支付"),
    O_003(3, "待发货"),
    O_004(4, "已发货"),
    O_005(5, "交易成功"),

    O_009(9, "已结束"),

    ;


    @Getter
    private Integer orderStatus;

    @Getter
    private String desc;

    TrainOrderStatusEnum(Integer orderStatus, String desc) {
        this.orderStatus = orderStatus;
        this.desc = desc;
    }
}
