package com.tydic.train.service.course.exception;

public class BaseBusinessException extends RuntimeException {
    private static final long serialVersionUID = 146688721847685861L;
    private String msgCode;
    private String[] args;

    public String getMsgCode() {
        return this.msgCode;
    }

    public String[] getArgs() {
        return this.args;
    }

    public String getMsgInfo() {
        return this.getMessage();
    }

    public BaseBusinessException(String msgId, String message) {
        super(message);
        this.msgCode = msgId;
    }

    public BaseBusinessException(String msgId, String message, Throwable cause) {
        super(message, cause);
        this.args = new String[1];
        this.args[0] = message;
        this.msgCode = msgId;
    }
}
