package com.tydic.train.service.ly.task.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 描述：任务实例表
 * 
 * @author liaoyang
 * @date 2023-08-30 15:50
 **/
@Data
public class TrainLYTaskInstBO implements Serializable {
	private static final long serialVersionUID = 7543285676884465659L;
	/**
	 * 任务id
	 */
	private String taskId;
	/**
	 * 流程实例id
	 */
	private String procInstId;
	/**
	 * 当前环节编码
	 */
	private String stepCode;
	/**
	 * 当前环节名称
	 */
	private String stepName;
	/**
	 * 环节状态:
            0：待处理
            1：已处理
	 */
	private Integer stepStatus;
	/**
	 * 待处理人id
	 */
	private String pendingUserId;
	/**
	 * 待处理人名称
	 */
	private String pendingUserName;
	/**
	 * 处理时间
	 */
	private Date dealTime;
	private Date dealTimeStart;
	private Date dealTimeEnd;
	/**
	 * 删除标记 ;0未删除  1已删除
	 */
	private Integer delFlag;
	/**
	 * 排序
	 */
	private String orderBy;

}
