package com.tydic.train.constants;

import lombok.Getter;

/**
 * 订单-流程状态映射
 */
public enum TrainLHLOrderStatusEnum {

    /**
     * 订单状态
     */
    O_000(0, "LHL0000", "订单审核中"),
    O_001(1, "LHL001", "待确认"),
    O_002(2, "LHL002", "待支付"),
    O_003(3, "LHL003", "待发货"),
    O_004(4, "", "已发货"),
    O_005(5, "", "已拒单"),
    O_006(6, "", "已取消"),
    O_007(7, "", "驳回");


    @Getter
    private Integer orderStatus;
    @Getter
    private String stepCode;
    @Getter
    private String desc;

    TrainLHLOrderStatusEnum(Integer orderStatus, String stepCode, String desc) {
        this.orderStatus = orderStatus;
        this.stepCode = stepCode;
        this.desc = desc;
    }

    /**
     * 通过环节找状态
     */
    public static Integer getStatusByStepCode(String stepCode) {
        for (TrainLHLOrderStatusEnum value : values()) {
            if (value.getStepCode().equals(stepCode)) {
                return value.orderStatus;
            }
        }
        return null;
    }
}
