package com.tydic.train.service.lsq.order.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 类名： TrainLsqQueryOrderRspBO
 * 说明：领域BO--订单查询-李世庆API--出参
 *
 * @author： lishiqing
 * 时间： 2023/8/28 17:05
 */
@Data
public class TrainLsqQueryOrderRspBO extends BaseRspBo {
    private static final long serialVersionUID = -7457631668418445239L;
    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 订单名称
     */
    private String orderName;

    /**
     * 订单总金额
     */
    private BigDecimal orderMoney;

    /**
     * 创建人
     */
    private Long createUserId;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 订单明细
     */
    private List<TrainLsqOrderItemBO> orderItemBOS;

    /**
     * 商品信息
     */
    private List<TrainLsqGoodsBO> goodsBOS;

    /**
     * 用户信息
     */
    private TrainLsqUserBO userBO;
}
