package com.tydic.train.service.course.bo.xwd;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 描述:
 *
 * @author XiaWD
 * @date 2023/8/31 15:36
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class TrainXWDTaskDealReqBO implements Serializable {
    /**
     * 流程实例id
     */
    private String procInstId;
    /**
     * 流程定义id
     */
    private String procDefId;
    /**
     * 流程key
     */
    private String procKey;
    /**
     * 业务单据id
     */
    private String objId;
    /**
     * 业务单据类型;业务单据类型:
     * 1:订单
     */
    private Integer objType;
    /**
     * 当前环节编码
     */
    private String stepCode;
    /**
     * 当前环节名称
     */
    private String stepName;
    /**
     * 流程是否结束;流程是否结束:
     * 0：未结束
     * 1：已结束
     */
    private Integer isFinish;
    /**
     * 已完成任务信息
     */
    private List<TrainXWDTaskBO> completedTaskList;
    private List<TrainXWDTaskBO> taskInstList;
    /**
     * 流程类： BUSINESS:业务流 APPROVAL：审批流
     */
    private String procType;
    /**
     *下一步任务信息 现在是审批接口用到这个
     */
    private List<TrainXWDTaskBO> nextTaskInfos;
}
