package com.tydic.train.service.gdx.order;

import com.tydic.train.service.gdx.order.bo.*;
import lombok.extern.ohaotian.HTServiceAPI;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/28 17:46
 */
@HTServiceAPI
public interface TrainGdxOrderService {

    /**
     * 批量创建批量订单
     *
     * @param batchOrderReqBo
     * @return
     */
    TrainGdxCreateBatchOrderRspBo createBatchOrder(TrainGdxCreateBatchOrderReqBo batchOrderReqBo);

    /**
     * 创建订单
     *
     * @param reqBo
     * @return
     */
    TrainGdxCreateOrderRspBo createOrder(TrainGdxCreateOrderReqBo reqBo);


    /**
     * 查询订单
     *
     * @param reqBo
     * @return
     */
    TrainGdxQueryOrderRspBo queryOrder(TrainGdxQueryOrderReqBo reqBo);

    /**
     * 修改订单
     *
     * @param reqBo
     * @return
     */
    TrainGdxUpdateRspBo updateOrder(TrainGdxUpdateOrderReqBo reqBo);

    /**
     * 修改订单状态
     *
     * @param reqBo
     * @return
     */
    TrainGdxUpdateRspBo updateOrderStatus(TrainGdxUpdateOrderStatusReqBo reqBo);


    /**
     * 同步订单
     *
     * @param reqBo
     * @return
     */
    TrainGdxSyncOrderRspBo syncOrder(TrainGdxQueryOrderReqBo reqBo);


}
