package com.tydic.train.service.task.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Hanwei
 * @version 1.0
 * @Desc TrainHWTaskDealReqBO
 * @ClassName TrainHWTaskDealReqBO
 * @date 2023/8/30 17:40
 */
@Data
public class TrainHWTaskDealReqBO implements Serializable {
    private static final long serialVersionUID = -7250205391557053269L;
    /**
     * 流程实例id
     */
    private String procInstId;
    /**
     * 流程定义id
     */
    private String procDefId;
    /**
     * 流程key
     */
    private String procKey;
    /**
     * 业务单据id
     */
    private String objId;
    /**
     * 业务单据类型;业务单据类型:
     * 1:订单
     */
    private Integer objType;
    /**
     * 当前环节编码
     */
    private String stepCode;
    /**
     * 当前环节名称
     */
    private String stepName;
    /**
     * 流程是否结束;流程是否结束:
     * 0：未结束
     * 1：已结束
     */
    private Integer isFinish;
    /**
     * 流程类： BUSINESS:业务流 APPROVAL：审批流
     */
    private String procType;

    /**
     * 父类流程实例ID
     */
    private String parentProcInstId;

    private List<TrainHWTaskBO> completedTaskList;
    private List<TrainHWTaskBO> taskInstList;

    /**
     * 环节是否结束(true:通过；false：驳回；undetermined：未审批完)
     */
    private String linkJudge;
}