package com.tydic.train.model.gdx.task.impl;

import com.tydic.train.model.gdx.task.TrainGdxProcessInstModel;
import com.tydic.train.repository.gdx.TrainGdxProcessInstRepository;
import com.tydic.train.repository.gdx.TrainGdxTaskInstRepository;
import com.tydic.train.service.gdx.task.bo.TrainGdxProcessInstBo;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/29 17:22
 */
@Service
@RequiredArgsConstructor
public class TrainGdxProcessInstModelImpl implements TrainGdxProcessInstModel {

    private final TrainGdxProcessInstRepository trainGdxProcessInstRepository;

    private final TrainGdxTaskInstRepository trainGdxTaskInstRepository;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createTask(TrainGdxProcessInstBo processInstBo) {

        trainGdxProcessInstRepository.createProcessInst(processInstBo);
        trainGdxTaskInstRepository.createBathTask(processInstBo.getProcInstId(), processInstBo.getTaskInstList());
    }
}
