package com.tydic.train.model.lsq.order;

import com.tydic.dyc.base.bo.RspBo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 类名： TrainLsqOrderDO
 * 说明：订单信息--持久化对象
 *
 * @author： lishiqing
 * 时间： 2023/8/28 17:05
 */
@Data
public class TrainLsqOrderDO extends RspBo {
    private static final long serialVersionUID = 1850443830854968724L;
    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 订单名称
     */
    private String orderName;

    /**
     * 订单总金额
     */
    private BigDecimal orderMoney;

    /**
     * 创建人
     */
    private Long createUserId;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 订单详情
     */
    private TrainLsqOrderItemDO itemDO;

    /**
     * 删除标识
     */
    private Integer delFlag;
}
