package com.tydic.train.model.lsq.order;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 类名： TrainLsqOrderItemDO
 * 说明：订单明细
 *
 * @author： lishiqing
 * 时间： 2023/8/28 17:12
 */
@Data
public class TrainLsqOrderItemDO implements Serializable {
    private static final long serialVersionUID = 2969356823511324742L;
    /**
     * 明细ID
     */
    private Long itemId;

    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 商品ID
     */
    private Long goodsId;

    /**
     * 商品价格
     */
    private BigDecimal goodsPrice;

    /**
     * 购买数量
     */
    private Integer count;

    /**
     * 总价小计
     */
    private BigDecimal totalMoney;

    /**
     * 删除标识
     */
    private Integer delFlag;
}
