package com.tydic.train.model.order.qrybo;

import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.train.service.order.bo.TrainHWOrderCreateSkuBO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author Hanwei
 * @version 1.0
 * @Desc TrainHWOrderCreateQryBo
 * @ClassName TrainHWOrderCreateQryBo
 * @date 2023/8/28 17:13
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TrainHWOrderCreateQryBo extends BaseReqBo {
    private static final long serialVersionUID = -9180193487800264715L;
    /**
     * 订单id
     */
    private Long orderId;
    /**
     * 订单编号
     */
    private String orderNo;
    /**
     * 订单名称
     */
    private String orderName;
    /**
     * 订单总金额
     */
    private BigDecimal orderMoney;
    /**
     * 创建人ID
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 商品信息
     */
    private List<TrainHWOrderCreateSkuBO> skuList;

}
