package com.tydic.train.model.tfqumc.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.tfqumc.TrainTfqUserModel;
import com.tydic.train.model.tfqumc.qrybo.TrainTfqUserQryBO;
import com.tydic.train.model.tfqumc.sub.TrainTfqUserDO;
import com.tydic.train.repository.TrainTfqUserRepository;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 标题 TrainTfqUserModelImpl
 * 说明 用户
 * 时间 2023/8/28 18:13
 *
 * @author 唐富强
 */
@Service
public class TrainTfqUserModelImpl implements TrainTfqUserModel {

    @Resource
    private TrainTfqUserRepository trainTfqUserRepository;

    /**
     * 用户查询
     * @param qryBO
     * @return
     */
    @Override
    public TrainTfqUserDO getModel(TrainTfqUserQryBO qryBO) {
        if(qryBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(qryBO.getUserId() == null){
            throw new ZTBusinessException("入参用户id不能为null");
        }
        return trainTfqUserRepository.getModel(qryBO);
    }
}
