package com.tydic.train.model.tfquoc.impl;

import com.alibaba.nacos.client.utils.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.tfquoc.sub.TrainTfqCreateOrderDO;
import com.tydic.train.model.tfquoc.sub.TrainTfqGoodsInfoDO;
import com.tydic.train.model.tfquoc.sub.TrainTfqOrderDetailsDO;
import com.tydic.train.model.tfquoc.sub.TrainTfqOrderItemDO;
import com.tydic.train.model.tfquoc.TrainTfqOrderModel;
import com.tydic.train.model.tfquoc.qrybo.TrainTfqOrderQryBO;
import com.tydic.train.repository.TrainTfqOrderRepository;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;

/**
 * 标题 TrainTfqOrderModelImpl
 * 说明 订单
 * 时间 2023/8/28 16:01
 *
 * @author 唐富强
 */
@Service
public class TrainTfqOrderModelImpl implements TrainTfqOrderModel {

    @Resource
    private TrainTfqOrderRepository trainTfqOrderRepository;

    /**
     * 订单详情查询
     * @param qryBO
     * @return
     */
    @Override
    public TrainTfqOrderDetailsDO getOrderDetails(TrainTfqOrderQryBO qryBO) {
        if(qryBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(qryBO.getOrderId() == null){
            throw new ZTBusinessException("入参订单id不能为null");
        }
        return trainTfqOrderRepository.getOrderDetails(qryBO);
    }

    @Override
    public void createOrder(TrainTfqCreateOrderDO createOrderDO) {
        if(createOrderDO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(createOrderDO.getCreateUserId() == null){
            throw new ZTBusinessException("入参【创建人id】不能为null");
        }
        if(StringUtils.isBlank(createOrderDO.getCreateUserName())){
            throw new ZTBusinessException("入参【创建人名称】不能为null");
        }
        if(CollectionUtils.isEmpty(createOrderDO.getGoodsInfoList())){
            throw new ZTBusinessException("入参商品信息集合不能为null");
        }

        for (TrainTfqGoodsInfoDO item: createOrderDO.getGoodsInfoList()) {
            if(item.getGoodsId() == null){
                throw new ZTBusinessException("入参订单明细【商品id】不能为null");
            }
            if(item.getGoodsPrice() == null){
                throw new ZTBusinessException("入参订单明细【商品价格】不能为null");
            }
            if(item.getGoodsPrice().compareTo(BigDecimal.ZERO) <= 0){
                throw new ZTBusinessException("入参订单明细【商品价格】必须为正数");
            }
            if(item.getCount() == null){
                throw new ZTBusinessException("入参订单明细【购买数量】不能为null");
            }
            if(item.getCount() <= 0){
                throw new ZTBusinessException("入参订单明细【购买数量】必须为正数");
            }
        }
        trainTfqOrderRepository.createOrder(createOrderDO);
    }

}
