package com.tydic.train.service;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.xsd.user.sub.TrainXsdUserDo;
import com.tydic.train.repository.xsdOrder.TrainXsdUserRepository;
import com.tydic.train.service.course.TrainXsdQryUserService;
import com.tydic.train.service.course.bo.TrainXsdQryUserReqBO;
import com.tydic.train.service.course.bo.TrainXsdQryUserRspBO;
import com.tydic.train.service.course.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

@HTServiceImpl
public class TrainXsdQryUserServiceImpl implements TrainXsdQryUserService {
    @Autowired
    private TrainXsdUserRepository trainXsdUserRepository;
    @Override
    public TrainXsdQryUserRspBO qryUserInfo(TrainXsdQryUserReqBO reqBO) {
        TrainXsdQryUserRspBO rspBO = new TrainXsdQryUserRspBO();
        if (reqBO.getUserId()==null){
            throw new ZTBusinessException("请传入用户ID");
        }
        TrainXsdUserDo trainXsdUserDo = new TrainXsdUserDo();
        trainXsdUserDo.setUserId(reqBO.getUserId());
        TrainXsdUserDo resultUser = trainXsdUserRepository.getUser(trainXsdUserDo);
        if (resultUser!=null){
            rspBO = JSONObject.parseObject(JSONObject.toJSONString(resultUser),TrainXsdQryUserRspBO.class);
        }
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
