package com.tydic.train.service.course;

import com.tydic.train.model.order.TrainLxjOrderModel;
import com.tydic.train.model.order.bo.TrainLxjOrderRepositoryReqBO;
import com.tydic.train.model.order.bo.TrainLxjOrderRepositoryRspBO;
import com.tydic.train.service.course.bo.TrainLxjOrderReqBO;
import com.tydic.train.service.course.bo.TrainLxjOrderRspBO;
import com.tydic.train.utils.JsonUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：
 * 说明：
 * 时间：2023/8/28
 *
 * @author：lantian
 **/
@HTServiceImpl
public class TrainLxjOrderServiceImpl implements TrainLxjOrderService {
    @Autowired
    private TrainLxjOrderModel trainLxjOrderModel;
    /**
     * 创建订单
     *
     * @param reqBO
     * @return
     */
    @Override
    public TrainLxjOrderRspBO createOrder(TrainLxjOrderReqBO reqBO) {
        TrainLxjOrderRepositoryRspBO rspBO = trainLxjOrderModel.createOrder(JsonUtil.js(reqBO, TrainLxjOrderRepositoryReqBO.class));
        return JsonUtil.js(rspBO,TrainLxjOrderRspBO.class);
    }

    /**
     * 查询订单
     *
     * @param reqBO
     * @return
     */
    @Override
    public TrainLxjOrderRspBO qryOrder(TrainLxjOrderReqBO reqBO) {
        TrainLxjOrderRepositoryRspBO rspBO = trainLxjOrderModel.qryOrder(JsonUtil.js(reqBO, TrainLxjOrderRepositoryReqBO.class));
        return JsonUtil.js(rspBO,TrainLxjOrderRspBO.class);
    }

    /**
     * 修改订单
     *
     * @param reqBO
     * @return
     */
    @Override
    public TrainLxjOrderRspBO updateOrder(TrainLxjOrderReqBO reqBO) {
        TrainLxjOrderRepositoryRspBO rspBO = trainLxjOrderModel.updateOrder(JsonUtil.js(reqBO, TrainLxjOrderRepositoryReqBO.class));
        return JsonUtil.js(rspBO,TrainLxjOrderRspBO.class);
    }
}
