package com.tydic.train.service.order;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.order.TrainZyyOrderDo;
import com.tydic.train.model.order.TrainZyyOrderModel;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.order.bo.TrainZyyCreateOrderReqBO;
import com.tydic.train.service.order.bo.TrainZyyCreateOrderRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：TrainZyyCreateOrderServiceImpl
 * 说明：周钰焱训练下单模拟服务实现
 * 时间：2023/8/28 16:14
 *
 * @author 周钰焱
 */
@HTServiceImpl
public class TrainZyyCreateOrderServiceImpl implements TrainZyyCreateOrderService {

    @Autowired
    private TrainZyyOrderModel trainZyyOrderModel;

    @Override
    public TrainZyyCreateOrderRspBO createOrder(TrainZyyCreateOrderReqBO reqBO) {
        TrainZyyCreateOrderRspBO rspBO = new TrainZyyCreateOrderRspBO();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        //入参校验
        checkReq(reqBO);
        TrainZyyOrderDo trainZyyOrderDo = trainZyyOrderModel.createOrder(reqBO);
        rspBO.setOrderId(trainZyyOrderDo.getOrderId());
        return rspBO;
    }

    /**
     * 入参校验
     */
    private void checkReq(TrainZyyCreateOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("入参不能为空");
        }
        if (null == reqBO.getCreateUserId()) {
            throw new ZTBusinessException("入参用户id不能为空");
        }
    }
}
