package com.tydic.train.service.order;

import com.alibaba.fastjson.JSONObject;
import com.tydic.train.model.order.TrainZyyOrderDo;
import com.tydic.train.model.order.TrainZyyOrderModel;
import com.tydic.train.model.order.qrybo.TrainZyyOrderQryBo;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.order.bo.TrainZyyQryOrderDetailReqBO;
import com.tydic.train.service.order.bo.TrainZyyQryOrderDetailRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：TrainZyyQryOrderDetailServiceImpl
 * 说明：周钰焱训练查询订单详情服务实现
 * 时间：2023/8/28 20:13
 *
 * @author 周钰焱
 */
@HTServiceImpl
public class TrainZyyQryOrderDetailServiceImpl implements TrainZyyQryOrderDetailService {
    @Autowired
    private TrainZyyOrderModel trainZyyOrderModel;

    @Override
    public TrainZyyQryOrderDetailRspBO qryOrderDetail(TrainZyyQryOrderDetailReqBO reqBO) {
        TrainZyyQryOrderDetailRspBO rspBo = new TrainZyyQryOrderDetailRspBO();
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        TrainZyyOrderQryBo orderQryBo = new TrainZyyOrderQryBo();
        BeanUtils.copyProperties(reqBO, orderQryBo);
        TrainZyyOrderDo orderDo = trainZyyOrderModel.qryOrderInfoSingle(orderQryBo);
        rspBo = JSONObject.parseObject(JSONObject.toJSONString(orderDo), TrainZyyQryOrderDetailRspBO.class);

        return rspBo;
    }
}
