package com.tydic.train.service.tfqucc;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.train.model.tfqucc.TrainTfqGoodsModel;
import com.tydic.train.model.tfqucc.qrybo.TrainTfqGoodsInfoQryBO;
import com.tydic.train.model.tfquoc.sub.TrainTfqGoodsInfoDO;
import com.tydic.train.service.tfqucc.api.TrainTfqQueryGoodsListService;
import com.tydic.train.service.tfqucc.bo.TrainTfqGoodsBO;
import com.tydic.train.service.tfqucc.bo.TrainTfqQueryGoodsListReqBO;
import com.tydic.train.service.tfqucc.bo.TrainTfqQueryGoodsListRspBO;
import lombok.extern.ohaotian.HTServiceImpl;

import javax.annotation.Resource;
import java.util.List;

/**
 * 标题 TrainTfqQueryGoodsListServiceImpl
 * 说明 商品列表查询
 * 时间 2023/8/28 18:04
 *
 * @author 唐富强
 */
@HTServiceImpl
public class TrainTfqQueryGoodsListServiceImpl implements TrainTfqQueryGoodsListService {

    @Resource
    private TrainTfqGoodsModel trainTfqGoodsModel;

    /**
     * 商品列表查询
     * @param reqBO
     * @return
     */
    @Override
    public TrainTfqQueryGoodsListRspBO queryGoodsList(TrainTfqQueryGoodsListReqBO reqBO) {
        TrainTfqQueryGoodsListRspBO rspBO = new TrainTfqQueryGoodsListRspBO();
        TrainTfqGoodsInfoQryBO trainTfqGoodsInfoQryBO = new TrainTfqGoodsInfoQryBO();
        trainTfqGoodsInfoQryBO.setGoodsIdList(reqBO.getGoodsIdList());
        List<TrainTfqGoodsInfoDO> list = trainTfqGoodsModel.getList(trainTfqGoodsInfoQryBO);
        rspBO.setGoodsList(JSONObject.parseArray(JSONObject.toJSONString(list), TrainTfqGoodsBO.class));
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        return rspBO;
    }
}
