package com.tydic.train.service.user;

import com.tydic.train.model.user.TrainHWUserDo;
import com.tydic.train.model.user.TrainHWUserModel;
import com.tydic.train.service.user.bo.TrainHWCreateOrderUserQryServiceReqBO;
import com.tydic.train.service.user.bo.TrainHWCreateOrderUserQryServiceRspBO;
import com.tydic.train.utils.JsonUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author Hanwei
 * @version 1.0
 * @Desc TrainHWCreateOrderUserQryService
 * @ClassName TrainHWCreateOrderUserQryService
 * @date 2023/8/28 17:03
 */
@HTServiceImpl
public class TrainHWCreateOrderUserQryServiceImpl implements TrainHWCreateOrderUserQryService {
    @Autowired
    private TrainHWUserModel trainHWUserModel;

    @Override
    public TrainHWCreateOrderUserQryServiceRspBO qryUser(TrainHWCreateOrderUserQryServiceReqBO reqBO) {
        TrainHWUserDo user = trainHWUserModel.qryUserById(reqBO.getUserId());
        return JsonUtil.js(user, TrainHWCreateOrderUserQryServiceRspBO.class);
    }
}
