package com.tydic.train.service.user;

import com.tydic.train.model.user.TrainLHLUserDO;
import com.tydic.train.model.user.TrainLHLUserModel;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.user.bo.TrainLHLUserBatchQryReqBO;
import com.tydic.train.service.user.bo.TrainLHLUserBatchQryRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HTServiceImpl
public class TrainLHLUserBatchQryServiceImpl implements TrainLHLUserBatchQryService {

    @Autowired
    private TrainLHLUserModel trainLHLUserModel;

    @Override
    public TrainLHLUserBatchQryRspBO userBatchQry(TrainLHLUserBatchQryReqBO reqBO) {
        TrainLHLUserBatchQryRspBO rspBO = new TrainLHLUserBatchQryRspBO();

        if (reqBO.getUserIdWeb() != null) {
            TrainLHLUserDO info = trainLHLUserModel.getInfo(reqBO.getUserIdWeb());
            if (info != null) {
                BeanUtils.copyProperties(info, rspBO);
            }
        }

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
