package com.tydic.train.model.lj.order.Impl;

import com.tydic.train.model.lj.order.TrainLjDealTaskDO;
import com.tydic.train.model.lj.order.TrainLjDealTaskModel;
import com.tydic.train.model.lj.order.TrainLjProcessInstBO;
import com.tydic.train.model.lj.order.TrainLjTaskInstBO;
import com.tydic.train.repository.lj.TrainLjProcessInstRepository;
import com.tydic.train.repository.lj.TrainLjTaskInstRepository;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @desc：
 * @author： liujian
 * @date： 2023/8/29 19:41
 **/
@Service
public class TrainLjDealTaskModelImpl implements TrainLjDealTaskModel {

    @Autowired
    private TrainLjProcessInstRepository trainLjProcessInstRepository;
    @Autowired
    private TrainLjTaskInstRepository trainLjTaskInstRepository;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void dealTaskInfo(TrainLjDealTaskDO trainLjDealTaskDO) {
        TrainLjProcessInstBO trainLjProcessInstBO = new TrainLjProcessInstBO();
        BeanUtils.copyProperties(trainLjProcessInstBO, trainLjProcessInstBO);
        trainLjProcessInstRepository.saveProcessInfo(trainLjProcessInstBO);
        trainLjTaskInstRepository.saveTaskInfo(trainLjDealTaskDO.getTaskInstList());
    }
}