package com.tydic.train.model.order;

import com.tydic.train.model.order.sub.TrainCyjOrderItem;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: DemoCoursePO
 * @Description: DemoCoursePO
 * @author: gujb
 * @date: 2022年09月20日14:52:28
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class TrainCyjOrderDo implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 订单id
	 */
	private Long orderId;
	/**
	 * 订单编号
	 */
	private String orderNo;
	/**
	 * 订单名称
	 */
	private String orderName;
	/**
	 * 订单金额
	 */
	private BigDecimal orderMoney;
	/**
	 * 创建人id
	 */
	private Long createUserId;
	/**
	 * 创建人名称
	 */
	private String createUserName;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 删除标记
	 */
	private Integer delFlag;
	/**
	 * 订单明细集合
	 */
	private List<TrainCyjOrderItem> itemDoList;

}