package com.tydic.train.service;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.xsd.order.TrainXsdOrderModel;
import com.tydic.train.model.xsd.order.sub.TrainXsdOrderDo;
import com.tydic.train.service.course.TrainXsdQryOrderService;
import com.tydic.train.service.course.bo.TrainXsdQryOrderReqBO;
import com.tydic.train.service.course.bo.TrainXsdQryOrderRspBO;
import com.tydic.train.service.course.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

@HTServiceImpl
public class TrainXsdQryOrderServiceImpl implements TrainXsdQryOrderService {
    @Autowired
    private TrainXsdOrderModel trainXsdOrderModel;
    @Override
    public TrainXsdQryOrderRspBO qryOrderInfo(TrainXsdQryOrderReqBO reqBO) {
        TrainXsdQryOrderRspBO rspBO = new TrainXsdQryOrderRspBO();
        if (reqBO.getOrderId()==null){
            throw new ZTBusinessException("请传入订单id");
        }
        TrainXsdOrderDo trainXsdOrderDo = new TrainXsdOrderDo();
        trainXsdOrderDo.setOrderId(reqBO.getOrderId());
        TrainXsdOrderDo resutOrder= trainXsdOrderModel.getOrder(trainXsdOrderDo);
        if (resutOrder!=null){
            rspBO = JSONObject.parseObject(JSONObject.toJSONString(resutOrder),TrainXsdQryOrderRspBO.class);
        }
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
