package com.tydic.train.service.commodity;

import com.tydic.train.model.commodity.TrainHWCommodityDo;
import com.tydic.train.model.commodity.TrainHWCommodityModel;
import com.tydic.train.service.commodity.bo.TrainHWCreateOrderCommodityQryBO;
import com.tydic.train.service.commodity.bo.TrainHWCreateOrderCommodityQryReqBO;
import com.tydic.train.service.commodity.bo.TrainHWCreateOrderCommodityQryRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Hanwei
 * @version 1.0
 * @Desc TrainHWCreateOrderCommodityQryServiceImpl
 * @ClassName TrainHWCreateOrderCommodityQryServiceImpl
 * @date 2023/8/28 18:31
 */
@HTServiceImpl
public class TrainHWCreateOrderCommodityQryServiceImpl implements TrainHWCreateOrderCommodityQryService {
    @Autowired
    private TrainHWCommodityModel trainHWCommodityModel;

    @Override
    public TrainHWCreateOrderCommodityQryRspBO qryCommodity(TrainHWCreateOrderCommodityQryReqBO reqBO) {
        //查询商品信息
        TrainHWCommodityDo commodityDo = trainHWCommodityModel.qryGoodsByIds(reqBO.getSkuList().stream().map(TrainHWCreateOrderCommodityQryBO::getSkuId).collect(Collectors.toList()));
        //校验商品信息（价格 库存）
        validateSpu(reqBO, commodityDo);

        List<TrainHWCreateOrderCommodityQryBO> collect = commodityDo.getCommoditySubBoList().stream().map(e -> {
            TrainHWCreateOrderCommodityQryBO bo = new TrainHWCreateOrderCommodityQryBO();
            bo.setGoodsName(e.getGoodsName());
            bo.setSkuId(e.getGoodsId());
            return bo;
        }).collect(Collectors.toList());
        //返回
        TrainHWCreateOrderCommodityQryRspBO trainHWCreateOrderCommodityQryRspBO = new TrainHWCreateOrderCommodityQryRspBO();
        trainHWCreateOrderCommodityQryRspBO.setSkuList(collect);
        return trainHWCreateOrderCommodityQryRspBO;
    }

    private void validateSpu(TrainHWCreateOrderCommodityQryReqBO reqBO, TrainHWCommodityDo commodityDo) {
        //校验价格

    }
}
