package com.tydic.train.service.gdx.task;

import com.tydic.train.model.gdx.task.TrainGdxProcessInstModel;
import com.tydic.train.service.course.exception.BaseBusinessException;
import com.tydic.train.service.gdx.task.bo.TrainGdxBpmTaskCreateReqBo;
import com.tydic.train.service.gdx.task.bo.TrainGdxBpmTaskCreateRspBo;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/29 17:46
 */
@HTServiceImpl
@RequiredArgsConstructor
public class TrainGdxBpmTaskServiceImpl implements TrainGdxBpmTaskService {

    private final TrainGdxProcessInstModel trainGdxProcessInstModel;

    @Override
    public TrainGdxBpmTaskCreateRspBo createTask(TrainGdxBpmTaskCreateReqBo reqBo) {
        if (reqBo == null || reqBo.getTrainProcess() == null) {
            throw new BaseBusinessException("1001", "参数错误");
        }
        trainGdxProcessInstModel.createTask(reqBo.getTrainProcess());
        return new TrainGdxBpmTaskCreateRspBo();
    }
}
