package com.tydic.train.service.goods;

import com.alibaba.fastjson.JSONArray;
import com.tydic.train.model.goods.TrainLHLGoodsDO;
import com.tydic.train.model.goods.TrainLHLGoodsModel;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.goods.TrainLHLGoodsBatchQryService;
import com.tydic.train.service.goods.bo.TrainLHLGoodsBatchQryBO;
import com.tydic.train.service.goods.bo.TrainLHLGoodsBatchQryReqBO;
import com.tydic.train.service.goods.bo.TrainLHLGoodsBatchQryRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

@HTServiceImpl
public class TrainLHLGoodsBatchQryServiceImpl implements TrainLHLGoodsBatchQryService {

    @Autowired
    private TrainLHLGoodsModel trainLHLGoodsModel;

    @Override
    public TrainLHLGoodsBatchQryRspBO goodsBatchQry(TrainLHLGoodsBatchQryReqBO reqBO) {
        TrainLHLGoodsBatchQryRspBO rspBO = new TrainLHLGoodsBatchQryRspBO();

        List<TrainLHLGoodsDO> byIds = trainLHLGoodsModel.getList(reqBO.getGoodsIds());
        if (!CollectionUtils.isEmpty(byIds)) {
            List<TrainLHLGoodsBatchQryBO> goodsInfo = new ArrayList<>();
            goodsInfo = JSONArray.parseArray(JSONArray.toJSONString(byIds), TrainLHLGoodsBatchQryBO.class);
            rspBO.setGoodsInfo(goodsInfo);
        }

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
