package com.tydic.train.service.lj;

import com.tydic.train.model.lj.order.TrainLjOrderCreateModel;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.lj.bo.TrainLjOrderCreateServiceReqBO;
import com.tydic.train.service.lj.bo.TrainLjOrderCreateServiceRspBO;
import lombok.Data;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @desc： 订单创建服务
 * @author： liujian
 * @date： 2023/8/29 16:28
 **/
@HTServiceImpl
public class TrainLjOrderCreateServiceImpl implements TrainLjOrderCreateService {

    @Autowired
    private TrainLjOrderCreateModel trainLjOrderCreateModel;

    @Override
    public TrainLjOrderCreateServiceRspBO dealOrderCreate(TrainLjOrderCreateServiceReqBO reqBO) {
        Long orderId = trainLjOrderCreateModel.saveOrderData(reqBO);
        TrainLjOrderCreateServiceRspBO rspBO = new TrainLjOrderCreateServiceRspBO();
        rspBO.setOrderId(orderId);
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}