package com.tydic.train.service.lsq.approval;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.train.model.lsq.approval.TrainLsqApprovalModel;
import com.tydic.train.model.lsq.approval.TrainLsqProcessInstDO;
import com.tydic.train.model.lsq.approval.sub.TrainLsqTaskInstDO;
import com.tydic.train.service.lsq.approval.bo.TrainLsqCreateApprovalReqBO;
import com.tydic.train.service.lsq.approval.bo.TrainLsqCreateApprovalRspBO;
import com.tydic.train.service.lsq.approval.bo.TrainLsqTaskInstBO;
import com.tydic.train.utils.JsonUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 类名： TrainLsqCreateApprovalService
 * 说明：领域服务--创建审批实例实现
 *
 * @author： lishiqing
 * 时间： 2023/8/29 17:37
 */
@HTServiceImpl
public class TrainLsqApprovalServiceImpl implements TrainLsqApprovalService {

    @Autowired
    private TrainLsqApprovalModel trainLsqApprovalModel;

    private static final Integer not_del = 0;

    @Override
    public TrainLsqCreateApprovalRspBO Approval(TrainLsqCreateApprovalReqBO reqBO) {
        // 判断流程实例是否存在
        TrainLsqProcessInstDO qryProcessInstDO = new TrainLsqProcessInstDO();
        qryProcessInstDO.setProcInstId(reqBO.getProcInstId());
        TrainLsqProcessInstDO processInstDO = trainLsqApprovalModel.qryProcessInst(qryProcessInstDO);
        if (ObjectUtil.isEmpty(processInstDO)) {
            // 新增审批实例
            TrainLsqProcessInstDO insetProcessInstDO = JsonUtil.js(reqBO, TrainLsqProcessInstDO.class);
            insetProcessInstDO.setDelFlag(not_del);
            trainLsqApprovalModel.insetProcessInst(insetProcessInstDO);
        } else {
            // 修改流程实例
            TrainLsqProcessInstDO updateProcessInstDO = JsonUtil.js(reqBO, TrainLsqProcessInstDO.class);
            trainLsqApprovalModel.updateProcessInst(updateProcessInstDO);
        }


        // 新增任务实例
        if (!ObjectUtil.isNotEmpty(reqBO.getTaskInstList())) {
            List<TrainLsqTaskInstDO> insetTaskList = new ArrayList<>();
            for (TrainLsqTaskInstBO taskInstBO : reqBO.getTaskInstList()) {
                // 判断任务是否存在
                TrainLsqTaskInstDO qryTaskInstDO = new TrainLsqTaskInstDO();
                qryTaskInstDO.setTaskId(taskInstBO.getTaskId());
                TrainLsqTaskInstDO taskInstDO = trainLsqApprovalModel.qryTaskInst(qryTaskInstDO);
                if (ObjectUtil.isEmpty(taskInstDO)) {
                    // 新增实例任务
                    TrainLsqTaskInstDO insetTaskInstDO = JsonUtil.js(taskInstBO, TrainLsqTaskInstDO.class);
                    insetTaskInstDO.setDelFlag(not_del);
                    insetTaskList.add(insetTaskInstDO);
                } else {
                    // 修改实例任务
                    TrainLsqTaskInstDO updateTaskInstDO = JsonUtil.js(taskInstBO, TrainLsqTaskInstDO.class);
                    trainLsqApprovalModel.updateTaskInst(updateTaskInstDO);
                }
            }
           if (ObjectUtil.isNotEmpty(insetTaskList)) {
               trainLsqApprovalModel.batchInsetTaskInst(insetTaskList);
           }
        }
        return new TrainLsqCreateApprovalRspBO();
    }
}
