package com.tydic.train.service.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.goods.TrainCyjGoodsDo;
import com.tydic.train.model.goods.TrainCyjGoodsModel;
import com.tydic.train.model.goods.qryBo.TrainCyjGoodsQryBo;
import com.tydic.train.model.order.TrainCyjOrderDo;
import com.tydic.train.model.order.TrainCyjOrderModel;
import com.tydic.train.model.order.qrybo.TrainCyjOrderQryBo;
import com.tydic.train.model.order.sub.TrainCyjOrderItem;
import com.tydic.train.model.user.TrainCyjUserDo;
import com.tydic.train.model.user.TrainCyjUserModel;
import com.tydic.train.model.user.qryBo.TrainCyjUserQryBo;
import com.tydic.train.service.order.bo.*;
import com.tydic.train.utils.JsonUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

@HTServiceImpl
public class TrainCyjOrderServiceImpl implements TrainCyjOrderService {
    @Autowired
    private TrainCyjOrderModel trainCyjOrderModel;
    @Autowired
    private TrainCyjGoodsModel trainCyjGoodsModel;
    @Autowired
    private TrainCyjUserModel trainCyjUserModel;

    @Override
    public TrainCyjCreateOrderRsqBo createOrder(TrainCyjCreateOrderReqBo reqBO) {
        TrainCyjCreateOrderRsqBo rsqBo = new TrainCyjCreateOrderRsqBo();
        // 校验参数
        validParam(reqBO);
        // 校验商品
        TrainCyjGoodsQryBo trainCyjGoodsQryBo = new TrainCyjGoodsQryBo();
        List<Long> goodsIds = reqBO.getItemDoList().stream().map(TrainCyjOrderItemBo::getGoodsId).distinct().collect(Collectors.toList());
        trainCyjGoodsQryBo.setGoodsIds(goodsIds);
        trainCyjGoodsModel.queryGoodsList(trainCyjGoodsQryBo);
        // 校验用户
        TrainCyjUserQryBo trainCyjUserQryBo = new TrainCyjUserQryBo();
        trainCyjUserQryBo.setUserId(reqBO.getCreateUserId());
        trainCyjUserModel.queryUserDetail(trainCyjUserQryBo);

        TrainCyjOrderDo trainCyjOrderDo = JSON.parseObject(JSONObject.toJSONString(reqBO), TrainCyjOrderDo.class);
        trainCyjOrderModel.createOrder(trainCyjOrderDo);
        return rsqBo;
    }

    public void validParam(TrainCyjCreateOrderReqBo reqBo) {
        if (StringUtils.isEmpty(reqBo.getOrderNo())) {
            throw new ZTBusinessException("订单编号不能为空");
        }
        if (StringUtils.isEmpty(reqBo.getOrderName())) {
            throw new ZTBusinessException("订单名称不能为空");
        }
        if (reqBo.getOrderMoney() == null) {
            throw new ZTBusinessException("订单金额不能为空");
        }
        if (CollectionUtils.isEmpty(reqBo.getItemDoList())) {
            throw new ZTBusinessException("订单明细不能为空");
        }
        for (TrainCyjOrderItemBo bo : reqBo.getItemDoList()) {
            if (bo.getGoodsId() == null) {
                throw new ZTBusinessException("商品id不能为空");
            }
            if (bo.getGoodsPrice() == null) {
                throw new ZTBusinessException("商品价格不能为空");
            }
            if (bo.getCount() == null) {
                throw new ZTBusinessException("购买数量不能为空");
            }
            bo.setTotalMoney(bo.getGoodsPrice().multiply(BigDecimal.valueOf(bo.getCount())));
        }
    }

    @Override
    public TrainCyjQryOrderDetailRsqBo qryOrderDetail(TrainCyjQryOrderDetailReqBo reqBO) {
        TrainCyjQryOrderDetailRsqBo rsqBo;
        if (reqBO.getOrderId() == null) {
            throw new ZTBusinessException("订单id不能为空");
        }

        // 查询订单信息
        TrainCyjOrderQryBo trainCyjOrderQryBo = JSON.parseObject(JSONObject.toJSONString(reqBO), TrainCyjOrderQryBo.class);
        TrainCyjOrderDo trainCyjOrderDo = trainCyjOrderModel.queryOrderDetail(trainCyjOrderQryBo);
        if (trainCyjOrderDo == null) {
            throw new ZTBusinessException("查询订单为空");
        }
        rsqBo = JsonUtil.js(trainCyjOrderModel.queryOrderDetail(trainCyjOrderQryBo), TrainCyjQryOrderDetailRsqBo.class);

        // 查询商品信息
        TrainCyjGoodsQryBo trainCyjGoodsQryBo = new TrainCyjGoodsQryBo();
        List<Long> goodsIds = trainCyjOrderDo.getItemDoList().stream().map(TrainCyjOrderItem::getGoodsId).distinct().collect(Collectors.toList());
        trainCyjGoodsQryBo.setGoodsIds(goodsIds);
        List<TrainCyjGoodsDo> goodsList = trainCyjGoodsModel.queryGoodsList(trainCyjGoodsQryBo);
        rsqBo.setGoodsList(JSON.parseArray(JSONObject.toJSONString(goodsList), TrainCyjGoodsBo.class));

        // 查询用户信息
        TrainCyjUserQryBo trainCyjUserQryBo = new TrainCyjUserQryBo();
        trainCyjUserQryBo.setUserId(trainCyjOrderDo.getCreateUserId());
        TrainCyjUserDo trainCyjUserDo = trainCyjUserModel.queryUserDetail(trainCyjUserQryBo);
        rsqBo.setUserInfo(JSON.parseObject(JSONObject.toJSONString(trainCyjUserDo), TrainCyjUserBo.class));

        return rsqBo;
    }
}

