package com.tydic.train.service.order;

import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.tydic.train.model.order.TrainHWOrderModel;
import com.tydic.train.model.order.qrybo.TrainHWOrderCreateQryBo;
import com.tydic.train.service.order.bo.TrainHWOrderCreateReqBO;
import com.tydic.train.service.order.bo.TrainHWOrderCreateRspBO;
import com.tydic.train.utils.JsonUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author Hanwei
 * @version 1.0
 * @Desc TrainHWOrderCreateServiceImpl
 * @ClassName TrainHWOrderCreateServiceImpl
 * @date 2023/8/28 16:12
 */
@HTServiceImpl
public class TrainHWOrderCreateServiceImpl implements TrainHWOrderCreateService {
    @Autowired
    private TrainHWOrderModel trainHWOrderModel;

    @Override
    public TrainHWOrderCreateRspBO createOrder(TrainHWOrderCreateReqBO reqBO) {
        TrainHWOrderCreateRspBO rspBo = JsonUtil.js(trainHWOrderModel.createOrder(JsonUtil.js(reqBO, TrainHWOrderCreateQryBo.class)), TrainHWOrderCreateRspBO.class);
        rspBo.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBo;
    }
}

