/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.train.model.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.constants.TrainHWRspConstant;
import com.tydic.train.model.order.TrainHWOrderModel;
import com.tydic.train.model.order.qrybo.TrainHWOrderChangeQryBO;
import com.tydic.train.model.order.sub.TrainHWShipCreateQryBO;
import com.tydic.train.model.order.sub.TrainHWShipCreateSubBO;
import com.tydic.train.model.workflow.TrainHWProcessTaskDo;
import com.tydic.train.model.workflow.TrainHWProcessTaskModel;
import com.tydic.train.model.workflow.qryBo.TrainHWProcessTaskQryBo;
import com.tydic.train.service.order.TrainHWInvoiceCreateService;
import com.tydic.train.service.order.bo.TrainHWInvoiceCreateReqBO;
import com.tydic.train.service.order.bo.TrainHWInvoiceCreateRspBO;
import com.tydic.train.service.pay.bo.TrainHWProcessTaskBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.train.service.order.TrainHWInvoiceCreateService"})
public class TrainHWInvoiceCreateServiceImpl
implements TrainHWInvoiceCreateService {
    @Autowired
    private TrainHWOrderModel trainHWOrderModel;
    @Autowired
    private TrainHWProcessTaskModel trainHWProcessTaskModel;

    @PostMapping(value={"createInvoice"})
    public TrainHWInvoiceCreateRspBO createInvoice(@RequestBody TrainHWInvoiceCreateReqBO reqBO) {
        this.validate(reqBO);
        TrainHWProcessTaskBo taskBo = this.validateProcess(reqBO);
        this.dealOrderStatusChange(reqBO);
        Long shipOrderId = this.dealCreateShipOrder(reqBO);
        TrainHWInvoiceCreateRspBO rspBO = new TrainHWInvoiceCreateRspBO();
        rspBO.setTaskId(taskBo.getTaskId());
        rspBO.setShipOrderId(shipOrderId);
        return rspBO;
    }

    private Long dealCreateShipOrder(TrainHWInvoiceCreateReqBO reqBO) {
        TrainHWShipCreateQryBO shipCreateQryBO = (TrainHWShipCreateQryBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), TrainHWShipCreateQryBO.class));
        TrainHWShipCreateSubBO shipCreateSubBO = this.trainHWOrderModel.createShipOrder(shipCreateQryBO);
        if (!"0".equals(shipCreateSubBO.getCode())) {
            throw new ZTBusinessException(shipCreateSubBO.getMessage());
        }
        return shipCreateSubBO.getShipOrderId();
    }

    private void dealOrderStatusChange(TrainHWInvoiceCreateReqBO reqBO) {
        TrainHWOrderChangeQryBO orderChangeQryBO = new TrainHWOrderChangeQryBO();
        orderChangeQryBO.setOrderStatus(TrainHWRspConstant.ORDER_STATUS.SHIPPED);
        orderChangeQryBO.setOrderId(reqBO.getOrderId());
        this.trainHWOrderModel.updateOrderStatus(orderChangeQryBO);
    }

    private TrainHWProcessTaskBo validateProcess(TrainHWInvoiceCreateReqBO reqBO) {
        TrainHWProcessTaskQryBo taskQryBo = new TrainHWProcessTaskQryBo();
        taskQryBo.setObjId(reqBO.getOrderId().toString());
        TrainHWProcessTaskDo taskDo = this.trainHWProcessTaskModel.qryProcees(taskQryBo);
        if ("0".equals(taskDo.getCode())) {
            if (CollectionUtils.isEmpty(taskDo.getTaskBoList()) || taskDo.getTaskBoList().size() > 1) {
                throw new ZTBusinessException("\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728 \u6216\u8005 \u5b58\u5728\u591a\u6761\u6fc0\u6d3b\u7684\u5b9e\u4f8b");
            }
            return taskDo.getTaskBoList().get(0);
        }
        throw new ZTBusinessException("\u6d41\u7a0b\u4efb\u52a1\u5b9e\u4f8b\u6821\u9a8c\u5931\u8d25");
    }

    private void validate(TrainHWInvoiceCreateReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getOrderId())) {
            throw new ZTBusinessException("\u53c2\u6570 orderId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getInvoiceDetailBOS())) {
            throw new ZTBusinessException("\u53c2\u6570 invoiceDetailBOS \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShipUserId())) {
            throw new ZTBusinessException("\u53c2\u6570 shipUserId \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

